/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.Session;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.TestingSession;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTimestampWithTimeZoneToTimeCast {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", "false").setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia")).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testCastToTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56 +07:09' AS TIME)")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1 +07:09' AS TIME)")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11 +07:09' AS TIME)")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 +07:09' AS TIME)")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 +07:09' AS TIME)")))).matches("TIME '12:34:56.556'");
    }
}

