/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.unnest;

import io.airlift.slice.Slice;
import io.prestosql.block.ColumnarTestUtils;
import io.prestosql.operator.unnest.ArrayOfRowsUnnester;
import io.prestosql.operator.unnest.TestingUnnesterUtil;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.PageBuilderStatus;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayOfRowsUnnester {
    @Test
    public void testWithoutMisAlignments() {
        int fieldCount = 2;
        int[] unnestedLengths = new int[]{2, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("0.0.0", "0.0.1"), TestingUnnesterUtil.toSlices("0.1.0", "0.1.1")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("1.0.0", "1.0.1")}));
        Block[] blocks = TestArrayOfRowsUnnester.testArrayOfRowsUnnester(unnestedLengths, unnestedLengths, elements, fieldCount);
        Assert.assertEquals((int)blocks.length, (int)2);
        Assert.assertTrue((boolean)(blocks[0] instanceof DictionaryBlock));
        Assert.assertTrue((boolean)(blocks[1] instanceof DictionaryBlock));
    }

    @Test
    public void testWithMisAlignments() {
        int fieldCount = 2;
        int[] unnestedLengths = new int[]{2, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("0.0.0", "0.0.1"), TestingUnnesterUtil.toSlices(null, "0.1.1")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("1.0.0", "1.0.1")}));
        int[] requiredCounts = new int[]{2, 2};
        Block[] blocks = TestArrayOfRowsUnnester.testArrayOfRowsUnnester(requiredCounts, unnestedLengths, elements, fieldCount);
        Assert.assertEquals((int)blocks.length, (int)2);
        Assert.assertTrue((boolean)(blocks[0] instanceof DictionaryBlock));
        Assert.assertFalse((boolean)(blocks[1] instanceof DictionaryBlock));
    }

    @Test
    public void testWithNullRowElement() {
        int fieldCount = 3;
        int[] requiredOutputCounts = new int[]{3, 1, 1, 0, 0};
        int[] unnestedLengths = new int[]{3, 1, 1, 0, 0};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("0.0.0", "0.0.1", null), null, TestingUnnesterUtil.toSlices("0.2.0", "0.2.1", "0.2.2")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("1.0.0", "1.0.1", "1.0.2")}), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices(null, "2.0.1", "2.0.2")}), null, TestingUnnesterUtil.array(new Slice[0][]));
        Block[] blocks = TestArrayOfRowsUnnester.testArrayOfRowsUnnester(requiredOutputCounts, unnestedLengths, elements, fieldCount);
        Assert.assertEquals((int)blocks.length, (int)3);
        Assert.assertTrue((boolean)(blocks[0] instanceof DictionaryBlock));
        Assert.assertFalse((boolean)(blocks[1] instanceof DictionaryBlock));
        Assert.assertTrue((boolean)(blocks[2] instanceof DictionaryBlock));
    }

    private static Block[] testArrayOfRowsUnnester(int[] requiredOutputCounts, int[] unnestedLengths, Slice[][][] elements, int fieldCount) {
        TestingUnnesterUtil.validateTestInput(requiredOutputCounts, unnestedLengths, elements, fieldCount);
        int positionCount = requiredOutputCounts.length;
        boolean[] containsNullRowElement = new boolean[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            containsNullRowElement[i] = false;
            if (elements[i] == null) continue;
            for (int j = 0; j < elements[i].length; ++j) {
                if (elements[i][j] != null) continue;
                containsNullRowElement[i] = true;
            }
        }
        boolean[] nullsPresent = new boolean[fieldCount];
        for (int field = 0; field < fieldCount; ++field) {
            nullsPresent[field] = TestingUnnesterUtil.nullExists(elements[field]);
        }
        RowType rowType = RowType.anonymous(Collections.nCopies(fieldCount, VarcharType.VARCHAR));
        ArrayOfRowsUnnester arrayofRowsUnnester = new ArrayOfRowsUnnester(rowType);
        Block arrayBlockOfRows = TestingUnnesterUtil.createArrayBlockOfRowBlocks(elements, rowType);
        Block[] blocks = null;
        for (int inputTestCount = 1; inputTestCount <= elements.length; ++inputTestCount) {
            PageBuilderStatus status = new PageBuilderStatus();
            arrayofRowsUnnester.resetInput(arrayBlockOfRows);
            Assert.assertEquals((int)arrayofRowsUnnester.getInputEntryCount(), (int)elements.length);
            arrayofRowsUnnester.startNewOutput(status, 10);
            boolean misAligned = false;
            for (int i = 0; i < inputTestCount; ++i) {
                int elementsSize;
                arrayofRowsUnnester.processCurrentAndAdvance(requiredOutputCounts[i]);
                int n = elementsSize = elements[i] != null ? elements[i].length : 0;
                if (requiredOutputCounts[i] <= elementsSize && !containsNullRowElement[i]) continue;
                misAligned = true;
            }
            blocks = arrayofRowsUnnester.buildOutputBlocksAndFlush();
            Assert.assertEquals((int)blocks.length, (int)rowType.getFields().size());
            for (int field = 0; field < blocks.length; ++field) {
                Assert.assertTrue((blocks[field] instanceof DictionaryBlock || !nullsPresent[field] && misAligned ? 1 : 0) != 0);
                Assert.assertFalse((blocks[field] instanceof DictionaryBlock && !nullsPresent[field] && misAligned ? 1 : 0) != 0);
                Slice[][] fieldElements = TestingUnnesterUtil.getFieldElements(elements, field);
                Slice[] expectedOutput = TestingUnnesterUtil.computeExpectedUnnestedOutput(fieldElements, requiredOutputCounts, 0, inputTestCount);
                ColumnarTestUtils.assertBlock(blocks[field], expectedOutput);
            }
        }
        return blocks;
    }

    @Test
    public void testTrimmedBlocks() {
        int fieldCount = 3;
        int[] unnestedLengths = new int[]{1, 2, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("0.0.0", "0.0.1", "0.0.2")}), TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("1.0.0", "1.0.1", "1.0.2"), TestingUnnesterUtil.toSlices("1.1.0", "1.1.1", "1.1.2")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("2.0.0", "2.0.1", "2.0.2")}));
        RowType rowType = RowType.anonymous(Collections.nCopies(fieldCount, VarcharType.VARCHAR));
        Block arrayOfRowBlock = TestingUnnesterUtil.createArrayBlockOfRowBlocks(elements, rowType);
        int startElement = 1;
        Slice[][][] truncatedSlices = (Slice[][][])Arrays.copyOfRange(elements, startElement, elements.length - startElement + 1);
        int[] truncatedUnnestedLengths = Arrays.copyOfRange(unnestedLengths, startElement, elements.length - startElement + 1);
        Block truncatedBlock = arrayOfRowBlock.getRegion(startElement, truncatedSlices.length);
        ArrayOfRowsUnnester arrayOfRowsUnnester = new ArrayOfRowsUnnester(rowType);
        arrayOfRowsUnnester.resetInput(truncatedBlock);
        arrayOfRowsUnnester.startNewOutput(new PageBuilderStatus(), 20);
        for (int i = 0; i < truncatedBlock.getPositionCount(); ++i) {
            arrayOfRowsUnnester.processCurrentAndAdvance(truncatedUnnestedLengths[i]);
        }
        Block[] output = arrayOfRowsUnnester.buildOutputBlocksAndFlush();
        Assert.assertEquals((int)Arrays.asList(truncatedSlices).stream().mapToInt(slice -> ((Slice[][])slice).length).sum(), (int)output[0].getPositionCount());
        for (int i = 0; i < fieldCount; ++i) {
            Slice[] expectedOutput = TestingUnnesterUtil.computeExpectedUnnestedOutput(TestingUnnesterUtil.getFieldElements(truncatedSlices, i), truncatedUnnestedLengths, 0, truncatedSlices.length);
            ColumnarTestUtils.assertBlock(output[i], expectedOutput);
        }
    }
}

