/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.unnest;

import io.airlift.slice.Slice;
import io.prestosql.block.ColumnarTestUtils;
import io.prestosql.operator.unnest.ArrayUnnester;
import io.prestosql.operator.unnest.TestingUnnesterUtil;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.PageBuilderStatus;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayUnnester {
    @Test
    public void testWithNullElement() {
        int[] unnestedLengths = new int[]{2, 1, 0, 1, 0};
        int[] requiredOutputCounts = new int[]{2, 2, 1, 1, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("0.0.0"), TestingUnnesterUtil.toSlices("0.1.0")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("1.0.0")}), null, TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices(new String[]{null})}), TestingUnnesterUtil.array(new Slice[0][]));
        Block[] blocks = TestArrayUnnester.testArrayUnnester(requiredOutputCounts, unnestedLengths, elements);
        Assert.assertTrue((boolean)(blocks[0] instanceof DictionaryBlock));
    }

    @Test
    public void testWithoutNullElement() {
        int[] unnestedLengths = new int[]{1, 1, 1, 0, 0};
        int[] requiredOutputCounts = new int[]{2, 2, 1, 1, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("0.0.0")}), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("1.0.0")}), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("2.0.0")}), null, TestingUnnesterUtil.array(new Slice[0][]));
        Block[] blocks = TestArrayUnnester.testArrayUnnester(requiredOutputCounts, unnestedLengths, elements);
        Assert.assertFalse((boolean)(blocks[0] instanceof DictionaryBlock));
    }

    private static Block[] testArrayUnnester(int[] requiredOutputCounts, int[] unnestedLengths, Slice[][][] elements) {
        Slice[][] slices = TestingUnnesterUtil.getFieldElements(elements, 0);
        TestingUnnesterUtil.validateTestInput(requiredOutputCounts, unnestedLengths, elements, 1);
        boolean nullPresent = TestingUnnesterUtil.nullExists(slices);
        ArrayUnnester arrayUnnester = new ArrayUnnester((Type)VarcharType.VARCHAR);
        Block arrayBlock = TestingUnnesterUtil.createArrayBlock(slices);
        Block[] blocks = null;
        for (int inputTestCount = 1; inputTestCount <= elements.length; ++inputTestCount) {
            arrayUnnester.resetInput(arrayBlock);
            Assert.assertEquals((int)arrayUnnester.getInputEntryCount(), (int)elements.length);
            PageBuilderStatus status = new PageBuilderStatus();
            arrayUnnester.startNewOutput(status, 10);
            boolean misAligned = false;
            for (int i = 0; i < inputTestCount; ++i) {
                int elementsSize = elements[i] != null ? elements[i].length : 0;
                Assert.assertEquals((int)arrayUnnester.getCurrentUnnestedLength(), (int)elementsSize);
                arrayUnnester.processCurrentAndAdvance(requiredOutputCounts[i]);
                if (requiredOutputCounts[i] <= elementsSize) continue;
                misAligned = true;
            }
            blocks = arrayUnnester.buildOutputBlocksAndFlush();
            Assert.assertEquals((int)blocks.length, (int)1);
            Assert.assertTrue((blocks[0] instanceof DictionaryBlock || !nullPresent && misAligned ? 1 : 0) != 0);
            Assert.assertFalse((blocks[0] instanceof DictionaryBlock && !nullPresent && misAligned ? 1 : 0) != 0);
            Slice[] expectedOutput = TestingUnnesterUtil.computeExpectedUnnestedOutput(slices, requiredOutputCounts, 0, inputTestCount);
            ColumnarTestUtils.assertBlock(blocks[0], expectedOutput);
        }
        return blocks;
    }

    @Test
    public void testTrimmedBlocks() {
        int[] unnestedLengths = new int[]{2, 1, 2, 3, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("0.0.0"), TestingUnnesterUtil.toSlices("0.1.0")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("1.0.0")}), TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("2.0.0"), TestingUnnesterUtil.toSlices("2.1.0")), TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("3.0.0"), TestingUnnesterUtil.toSlices("3.1.0"), TestingUnnesterUtil.toSlices("3.2.0")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("4.0.0")}));
        Slice[][] slices = TestingUnnesterUtil.getFieldElements(elements, 0);
        Block arrayBlock = TestingUnnesterUtil.createArrayBlock(slices);
        int startElement = 1;
        Slice[][] truncatedSlices = (Slice[][])Arrays.copyOfRange(slices, startElement, slices.length - startElement + 1);
        int[] truncatedUnnestedLengths = Arrays.copyOfRange(unnestedLengths, startElement, slices.length - startElement + 1);
        Block truncatedBlock = arrayBlock.getRegion(startElement, truncatedSlices.length);
        ColumnarTestUtils.assertBlock(truncatedBlock, truncatedSlices);
        ArrayUnnester arrayUnnester = new ArrayUnnester((Type)VarcharType.VARCHAR);
        arrayUnnester.resetInput(truncatedBlock);
        arrayUnnester.startNewOutput(new PageBuilderStatus(), 20);
        for (int i = 0; i < truncatedBlock.getPositionCount(); ++i) {
            arrayUnnester.processCurrentAndAdvance(truncatedUnnestedLengths[i]);
        }
        Block[] output = arrayUnnester.buildOutputBlocksAndFlush();
        Assert.assertEquals((int)Arrays.asList(truncatedSlices).stream().mapToInt(slice -> ((Slice[])slice).length).sum(), (int)output[0].getPositionCount());
        Slice[] expectedOutput = TestingUnnesterUtil.computeExpectedUnnestedOutput(truncatedSlices, truncatedUnnestedLengths, 0, truncatedSlices.length);
        ColumnarTestUtils.assertBlock(output[0], expectedOutput);
    }
}

