/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStats;
import io.prestosql.operator.BlockedReason;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.eventlistener.StageGcStatistics;
import io.prestosql.spi.memory.MemoryPoolId;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBasicQueryInfo {
    @Test
    public void testConstructor() {
        BasicQueryInfo basicInfo = new BasicQueryInfo(new QueryInfo(new QueryId("0"), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), QueryState.RUNNING, new MemoryPoolId("reserved"), false, URI.create("1"), (List)ImmutableList.of((Object)"2", (Object)"3"), "SELECT 4", Optional.empty(), new QueryStats(DateTime.parse((String)"1991-09-06T05:00-05:30"), DateTime.parse((String)"1991-09-06T05:01-05:30"), DateTime.parse((String)"1991-09-06T05:02-05:30"), DateTime.parse((String)"1991-09-06T06:00-05:30"), Duration.valueOf((String)"8m"), Duration.valueOf((String)"7m"), Duration.valueOf((String)"34m"), Duration.valueOf((String)"35m"), Duration.valueOf((String)"44m"), Duration.valueOf((String)"9m"), Duration.valueOf((String)"99s"), Duration.valueOf((String)"12m"), 13, 14, 15, 16, 17, 18, 34, 19, 20.0, DataSize.valueOf((String)"21GB"), DataSize.valueOf((String)"22GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"24GB"), DataSize.valueOf((String)"25GB"), DataSize.valueOf((String)"30GB"), DataSize.valueOf((String)"26GB"), DataSize.valueOf((String)"27GB"), DataSize.valueOf((String)"28GB"), DataSize.valueOf((String)"29GB"), true, Duration.valueOf((String)"23m"), Duration.valueOf((String)"24m"), Duration.valueOf((String)"26m"), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), DataSize.valueOf((String)"271GB"), 281L, Duration.valueOf((String)"20m"), DataSize.valueOf((String)"272GB"), 282L, DataSize.valueOf((String)"27GB"), 28L, DataSize.valueOf((String)"29GB"), 30L, DataSize.valueOf((String)"31GB"), 32L, DataSize.valueOf((String)"32GB"), (List)ImmutableList.of((Object)new StageGcStatistics(101, 102, 103, 104, 105, 106, 107)), (List)ImmutableList.of()), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "33", Optional.empty(), null, StandardErrorCode.ABANDONED_QUERY.toErrorCode(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), false, Optional.empty()));
        Assert.assertEquals((String)basicInfo.getQueryId().getId(), (String)"0");
        Assert.assertEquals((Object)basicInfo.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((String)basicInfo.getMemoryPool().getId(), (String)"reserved");
        Assert.assertEquals((boolean)basicInfo.isScheduled(), (boolean)false);
        Assert.assertEquals((String)basicInfo.getQuery(), (String)"SELECT 4");
        Assert.assertEquals((Object)basicInfo.getQueryStats().getCreateTime(), (Object)DateTime.parse((String)"1991-09-06T05:00-05:30"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getEndTime(), (Object)DateTime.parse((String)"1991-09-06T06:00-05:30"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getElapsedTime(), (Object)Duration.valueOf((String)"8m"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getExecutionTime(), (Object)Duration.valueOf((String)"44m"));
        Assert.assertEquals((int)basicInfo.getQueryStats().getTotalDrivers(), (int)16);
        Assert.assertEquals((int)basicInfo.getQueryStats().getQueuedDrivers(), (int)17);
        Assert.assertEquals((int)basicInfo.getQueryStats().getRunningDrivers(), (int)18);
        Assert.assertEquals((int)basicInfo.getQueryStats().getCompletedDrivers(), (int)19);
        Assert.assertEquals((Object)basicInfo.getQueryStats().getCumulativeUserMemory(), (Object)20.0);
        Assert.assertEquals((Object)basicInfo.getQueryStats().getUserMemoryReservation(), (Object)DataSize.valueOf((String)"21GB"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getTotalMemoryReservation(), (Object)DataSize.valueOf((String)"23GB"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getPeakUserMemoryReservation(), (Object)DataSize.valueOf((String)"24GB"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getTotalCpuTime(), (Object)Duration.valueOf((String)"24m"));
        Assert.assertEquals((boolean)basicInfo.getQueryStats().isFullyBlocked(), (boolean)true);
        Assert.assertEquals((Set)basicInfo.getQueryStats().getBlockedReasons(), (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getProgressPercentage(), (Object)OptionalDouble.of(100.0));
        Assert.assertEquals((Object)basicInfo.getErrorCode(), (Object)StandardErrorCode.ABANDONED_QUERY.toErrorCode());
        Assert.assertEquals((Object)basicInfo.getErrorType(), (Object)StandardErrorCode.ABANDONED_QUERY.toErrorCode().getType());
    }
}

