/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageState;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.TestingColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.tree.Expression;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDynamicFilterService {
    @Test
    public void testDynamicFilterSummaryCompletion() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(new TaskManagerConfig());
        DynamicFilterId filterId = new DynamicFilterId("df");
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        ImmutableList taskIds = ImmutableList.of((Object)new TaskId(stageId, 0), (Object)new TaskId(stageId, 1), (Object)new TaskId(stageId, 2));
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        TestDynamicFiltersStageSupplier dynamicFiltersStageSupplier = new TestDynamicFiltersStageSupplier(StageState.RUNNING);
        dynamicFiltersStageSupplier.addTasks((List<TaskId>)taskIds);
        dynamicFilterService.registerQuery(queryId, (Supplier)dynamicFiltersStageSupplier, (Set)ImmutableSet.of((Object)DynamicFilterService.SourceDescriptor.of((QueryId)queryId, (DynamicFilterId)filterId)), (Set)ImmutableSet.of());
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        dynamicFiltersStageSupplier.storeSummary(filterId, new TaskId(stageId, 0), Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)1);
        dynamicFiltersStageSupplier.storeSummary(filterId, new TaskId(stageId, 1), Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)2);
        dynamicFiltersStageSupplier.storeSummary(filterId, new TaskId(stageId, 2), Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L));
        dynamicFilterService.collectDynamicFilters();
        Optional summary = dynamicFilterService.getSummary(queryId, filterId);
        Assert.assertTrue((boolean)summary.isPresent());
        Assert.assertEquals(summary.get(), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)3);
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)3);
    }

    @Test
    public void testDynamicFilterSupplier() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(new TaskManagerConfig());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        DynamicFilterId filterId3 = new DynamicFilterId("df3");
        Expression df1 = PlanBuilder.expression("DF_SYMBOL1");
        Expression df2 = PlanBuilder.expression("DF_SYMBOL2");
        Expression df3 = PlanBuilder.expression("DF_SYMBOL3");
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        StageId stageId2 = new StageId(queryId, 2);
        StageId stageId3 = new StageId(queryId, 3);
        Supplier dynamicFilterSupplier = dynamicFilterService.createDynamicFilterSupplier(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, df1), (Object)new DynamicFilters.Descriptor(filterId2, df2), (Object)new DynamicFilters.Descriptor(filterId3, df3)), (Map)ImmutableMap.of((Object)Symbol.from((Expression)df1), (Object)new TestingColumnHandle("probeColumnA"), (Object)Symbol.from((Expression)df2), (Object)new TestingColumnHandle("probeColumnA"), (Object)Symbol.from((Expression)df3), (Object)new TestingColumnHandle("probeColumnB")));
        Assert.assertTrue((boolean)((TupleDomain)dynamicFilterSupplier.get()).isAll());
        TestDynamicFiltersStageSupplier dynamicFiltersStageSupplier = new TestDynamicFiltersStageSupplier(StageState.RUNNING);
        dynamicFiltersStageSupplier.addTasks((List<TaskId>)ImmutableList.of((Object)new TaskId(stageId1, 0), (Object)new TaskId(stageId1, 1)));
        dynamicFiltersStageSupplier.addTasks((List<TaskId>)ImmutableList.of((Object)new TaskId(stageId2, 0), (Object)new TaskId(stageId2, 1)));
        dynamicFiltersStageSupplier.addTasks((List<TaskId>)ImmutableList.of((Object)new TaskId(stageId3, 0), (Object)new TaskId(stageId3, 1)));
        dynamicFilterService.registerQuery(queryId, (Supplier)dynamicFiltersStageSupplier, (Set)ImmutableSet.of((Object)DynamicFilterService.SourceDescriptor.of((QueryId)queryId, (DynamicFilterId)filterId1), (Object)DynamicFilterService.SourceDescriptor.of((QueryId)queryId, (DynamicFilterId)filterId2), (Object)DynamicFilterService.SourceDescriptor.of((QueryId)queryId, (DynamicFilterId)filterId3)), (Set)ImmutableSet.of());
        Assert.assertTrue((boolean)((TupleDomain)dynamicFilterSupplier.get()).isAll());
        dynamicFiltersStageSupplier.storeSummary(filterId1, new TaskId(stageId1, 0), Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertTrue((boolean)((TupleDomain)dynamicFilterSupplier.get()).isAll());
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)1);
        dynamicFiltersStageSupplier.storeSummary(filterId1, new TaskId(stageId1, 1), Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals(dynamicFilterSupplier.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)2);
        dynamicFiltersStageSupplier.storeSummary(filterId2, new TaskId(stageId2, 0), Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals(dynamicFilterSupplier.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)3);
        dynamicFiltersStageSupplier.storeSummary(filterId2, new TaskId(stageId2, 1), Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals(dynamicFilterSupplier.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)4);
        dynamicFiltersStageSupplier.storeSummary(filterId3, new TaskId(stageId3, 0), Domain.none((Type)IntegerType.INTEGER));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals(dynamicFilterSupplier.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)5);
        dynamicFiltersStageSupplier.storeSummary(filterId3, new TaskId(stageId3, 1), Domain.none((Type)IntegerType.INTEGER));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals(dynamicFilterSupplier.get(), (Object)TupleDomain.none());
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)6);
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)6);
    }

    @Test
    public void testReplicatedDynamicFilterSupplier() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(new TaskManagerConfig());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        Expression df1 = PlanBuilder.expression("DF_SYMBOL1");
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        TestDynamicFiltersStageSupplier dynamicFiltersStageSupplier = new TestDynamicFiltersStageSupplier(StageState.SCHEDULING);
        dynamicFiltersStageSupplier.addTasks((List<TaskId>)ImmutableList.of((Object)new TaskId(stageId1, 0), (Object)new TaskId(stageId1, 1)));
        dynamicFilterService.registerQuery(queryId, (Supplier)dynamicFiltersStageSupplier, (Set)ImmutableSet.of((Object)DynamicFilterService.SourceDescriptor.of((QueryId)queryId, (DynamicFilterId)filterId1)), (Set)ImmutableSet.of((Object)filterId1));
        Supplier dynamicFilterSupplier = dynamicFilterService.createDynamicFilterSupplier(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, df1)), (Map)ImmutableMap.of((Object)Symbol.from((Expression)df1), (Object)new TestingColumnHandle("probeColumnA")));
        Assert.assertTrue((boolean)((TupleDomain)dynamicFilterSupplier.get()).isAll());
        dynamicFiltersStageSupplier.storeSummary(filterId1, new TaskId(stageId1, 0), Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L));
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals(dynamicFilterSupplier.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)1);
        dynamicFilterService.collectDynamicFilters();
        Assert.assertEquals((int)dynamicFiltersStageSupplier.getRequestCount(), (int)1);
    }

    private static class TestDynamicFiltersStageSupplier
    implements Supplier<List<DynamicFilterService.StageDynamicFilters>> {
        private final Map<StageId, Map<TaskId, Map<DynamicFilterId, Domain>>> stageDynamicFilters = new HashMap<StageId, Map<TaskId, Map<DynamicFilterId, Domain>>>();
        private final StageState stageState;
        private int requestCount;

        TestDynamicFiltersStageSupplier(StageState stageState) {
            this.stageState = stageState;
        }

        void addTasks(List<TaskId> taskIds) {
            taskIds.stream().forEach(taskId -> this.stageDynamicFilters.computeIfAbsent(taskId.getStageId(), id -> new HashMap()).put(taskId, new HashMap()));
        }

        void storeSummary(DynamicFilterId filterId, TaskId taskId, Domain domain) {
            StageId stageId = taskId.getStageId();
            this.stageDynamicFilters.get(stageId).get(taskId).put(filterId, domain);
        }

        int getRequestCount() {
            return this.requestCount;
        }

        @Override
        public List<DynamicFilterService.StageDynamicFilters> get() {
            ++this.requestCount;
            return ImmutableList.copyOf((Collection)((Collection)this.stageDynamicFilters.values().stream().map(stage -> new DynamicFilterService.StageDynamicFilters(this.stageState, stage.size(), (List)stage.values().stream().collect(ImmutableList.toImmutableList()))).collect(ImmutableList.toImmutableList())));
        }
    }
}

