/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.airlift.jaxrs.testing.GuavaMultivaluedMap;
import io.prestosql.server.HttpRequestSessionContext;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.SelectedRole;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpRequestSessionContext {
    @Test
    public void testSessionContext() {
        GuavaMultivaluedMap headers = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Path", (Object)"testPath").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"client-info").put((Object)"X-Presto-Session", (Object)"query_max_memory=1GB").put((Object)"X-Presto-Session", (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)"X-Presto-Session", (Object)"some_session_property=some value with %2C comma").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from foo,query2=select * from bar").put((Object)"X-Presto-Role", (Object)"foo_connector=ALL").put((Object)"X-Presto-Role", (Object)"bar_connector=NONE").put((Object)"X-Presto-Role", (Object)"foobar_connector=ROLE{role}").put((Object)"X-Presto-Extra-Credential", (Object)"test.token.foo=bar").put((Object)"X-Presto-Extra-Credential", (Object)"test.token.abc=xyz").build());
        HttpRequestSessionContext context = new HttpRequestSessionContext((MultivaluedMap)headers, "testRemote", Optional.empty(), ImmutableSet::of);
        Assert.assertEquals((String)context.getSource(), (String)"testSource");
        Assert.assertEquals((String)context.getCatalog(), (String)"testCatalog");
        Assert.assertEquals((String)context.getSchema(), (String)"testSchema");
        Assert.assertEquals((String)context.getPath(), (String)"testPath");
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.ofUser((String)"testUser"));
        Assert.assertEquals((String)context.getClientInfo(), (String)"client-info");
        Assert.assertEquals((String)context.getLanguage(), (String)"zh-TW");
        Assert.assertEquals((String)context.getTimeZoneId(), (String)"Asia/Taipei");
        Assert.assertEquals((Map)context.getSystemProperties(), (Map)ImmutableMap.of((Object)"query_max_memory", (Object)"1GB", (Object)"join_distribution_type", (Object)"partitioned", (Object)"hash_partition_count", (Object)"43", (Object)"some_session_property", (Object)"some value with , comma"));
        Assert.assertEquals((Map)context.getPreparedStatements(), (Map)ImmutableMap.of((Object)"query1", (Object)"select * from foo", (Object)"query2", (Object)"select * from bar"));
        Assert.assertEquals((Map)context.getIdentity().getRoles(), (Map)ImmutableMap.of((Object)"foo_connector", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty()), (Object)"bar_connector", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty()), (Object)"foobar_connector", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))));
        Assert.assertEquals((Map)context.getIdentity().getExtraCredentials(), (Map)ImmutableMap.of((Object)"test.token.foo", (Object)"bar", (Object)"test.token.abc", (Object)"xyz"));
        Assert.assertEquals((Set)context.getIdentity().getGroups(), (Set)ImmutableSet.of((Object)"testUser"));
    }

    @Test
    public void testMappedUser() {
        GuavaMultivaluedMap userHeaders = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.of((Object)"X-Presto-User", (Object)"testUser"));
        MultivaluedHashMap emptyHeaders = new MultivaluedHashMap();
        HttpRequestSessionContext context = new HttpRequestSessionContext((MultivaluedMap)userHeaders, "testRemote", Optional.empty(), ImmutableSet::of);
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.forUser((String)"testUser").withGroups((Set)ImmutableSet.of((Object)"testUser")).build());
        context = new HttpRequestSessionContext((MultivaluedMap)emptyHeaders, "testRemote", Optional.of(Identity.forUser((String)"mappedUser").withGroups((Set)ImmutableSet.of((Object)"test")).build()), ImmutableSet::of);
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.forUser((String)"mappedUser").withGroups((Set)ImmutableSet.of((Object)"test", (Object)"mappedUser")).build());
        context = new HttpRequestSessionContext((MultivaluedMap)userHeaders, "testRemote", Optional.of(Identity.ofUser((String)"mappedUser")), ImmutableSet::of);
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.forUser((String)"testUser").withGroups((Set)ImmutableSet.of((Object)"testUser")).build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHttpRequestSessionContext.lambda$testMappedUser$1((MultivaluedMap)emptyHeaders)).isInstanceOf(WebApplicationException.class)).matches(e -> ((WebApplicationException)e).getResponse().getStatus() == 400);
    }

    @Test
    public void testPreparedStatementsHeaderDoesNotParse() {
        GuavaMultivaluedMap headers = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Path", (Object)"testPath").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"null").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=abcdefg").build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHttpRequestSessionContext.lambda$testPreparedStatementsHeaderDoesNotParse$4((MultivaluedMap)headers)).isInstanceOf(WebApplicationException.class)).hasMessageMatching("Invalid X-Presto-Prepared-Statement header: line 1:1: mismatched input 'abcdefg'. Expecting: .*");
    }

    private static /* synthetic */ void lambda$testPreparedStatementsHeaderDoesNotParse$4(MultivaluedMap headers) throws Throwable {
        new HttpRequestSessionContext(headers, "testRemote", Optional.empty(), user -> ImmutableSet.of());
    }

    private static /* synthetic */ void lambda$testMappedUser$1(MultivaluedMap emptyHeaders) throws Throwable {
        new HttpRequestSessionContext(emptyHeaders, "testRemote", Optional.empty(), user -> ImmutableSet.of());
    }
}

