/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import io.prestosql.client.QueryResults;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.assertions.Assert;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestQueryResource {
    private HttpClient client;
    private TestingPrestoServer server;

    @BeforeMethod
    public void setup() {
        this.client = new JettyHttpClient();
        this.server = TestingPrestoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testGetQueryInfos() {
        this.runToCompletion("SELECT 1");
        this.runToCompletion("SELECT 2");
        this.runToCompletion("SELECT x FROM y");
        List<BasicQueryInfo> infos = this.getQueryInfos("/v1/query");
        Assert.assertEquals((int)infos.size(), (int)3);
        TestQueryResource.assertStateCounts(infos, 2, 1, 0);
        infos = this.getQueryInfos("/v1/query?state=finished");
        Assert.assertEquals((int)infos.size(), (int)2);
        TestQueryResource.assertStateCounts(infos, 2, 0, 0);
        infos = this.getQueryInfos("/v1/query?state=failed");
        Assert.assertEquals((int)infos.size(), (int)1);
        TestQueryResource.assertStateCounts(infos, 0, 1, 0);
        infos = this.getQueryInfos("/v1/query?state=running");
        Assert.assertEquals((int)infos.size(), (int)0);
        TestQueryResource.assertStateCounts(infos, 0, 0, 0);
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            org.testng.Assert.assertTrue((boolean)this.getQueryInfos("/v1/query").isEmpty());
            org.testng.Assert.assertTrue((boolean)this.getQueryInfos("/v1/query?state=finished").isEmpty());
            org.testng.Assert.assertTrue((boolean)this.getQueryInfos("/v1/query?state=failed").isEmpty());
            org.testng.Assert.assertTrue((boolean)this.getQueryInfos("/v1/query?state=running").isEmpty());
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryInfoDispatchFailure() {
        String queryId = this.runToCompletion("SELECT");
        QueryInfo info = this.getQueryInfo(queryId);
        org.testng.Assert.assertFalse((boolean)info.isScheduled());
        org.testng.Assert.assertNotNull((Object)info.getFailureInfo());
        Assert.assertEquals((Object)info.getFailureInfo().getErrorCode(), (Object)StandardErrorCode.SYNTAX_ERROR.toErrorCode());
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getQueryInfo(queryId)).isInstanceOf(UnexpectedResponseException.class)).matches(throwable -> ((UnexpectedResponseException)throwable).getStatusCode() == 403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryInfoExecutionFailure() {
        String queryId = this.runToCompletion("SELECT cast(rand() AS integer) / 0");
        QueryInfo info = this.getQueryInfo(queryId);
        org.testng.Assert.assertTrue((boolean)info.isScheduled());
        org.testng.Assert.assertNotNull((Object)info.getFailureInfo());
        Assert.assertEquals((Object)info.getFailureInfo().getErrorCode(), (Object)StandardErrorCode.DIVISION_BY_ZERO.toErrorCode());
    }

    @Test
    public void testCancel() {
        String queryId = this.startQuery("SELECT * FROM tpch.sf100.lineitem");
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.KILL_QUERY)});
        try {
            Assert.assertEquals((int)this.cancelQueryInfo(queryId), (int)403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
        Assert.assertEquals((int)this.cancelQueryInfo(queryId), (int)204);
        Assert.assertEquals((int)this.cancelQueryInfo(queryId), (int)204);
        BasicQueryInfo queryInfo = this.server.getDispatchManager().getQueryInfo(new QueryId(queryId));
        Assert.assertEquals((Object)queryInfo.getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)StandardErrorCode.USER_CANCELED.toErrorCode());
    }

    @Test
    public void testKilled() {
        this.testKilled("killed");
    }

    @Test
    public void testPreempted() {
        this.testKilled("preempted");
    }

    private void testKilled(String killType) {
        String queryId = this.startQuery("SELECT * FROM tpch.sf100.lineitem");
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.KILL_QUERY)});
        try {
            Assert.assertEquals((int)this.killQueryInfo(queryId, killType), (int)403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
        Assert.assertEquals((int)this.killQueryInfo(queryId, killType), (int)202);
        Assert.assertEquals((int)this.killQueryInfo(queryId, killType), (int)409);
        BasicQueryInfo queryInfo = this.server.getDispatchManager().getQueryInfo(new QueryId(queryId));
        Assert.assertEquals((Object)queryInfo.getState(), (Object)QueryState.FAILED);
        if (killType.equals("killed")) {
            Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)StandardErrorCode.ADMINISTRATIVELY_KILLED.toErrorCode());
        } else {
            Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode());
        }
    }

    private String runToCompletion(String sql) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl().resolve("/v1/statement")).build();
        Request request = Request.Builder.preparePost().setHeader("X-Presto-User", "user").setUri(uri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)sql, (Charset)StandardCharsets.UTF_8)).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        while (queryResults.getNextUri() != null) {
            request = Request.Builder.prepareGet().setHeader("X-Presto-User", "user").setUri(queryResults.getNextUri()).build();
            queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        }
        return queryResults.getId();
    }

    private String startQuery(String sql) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build();
        Request request = Request.Builder.preparePost().setUri(uri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)sql, (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        while (queryResults.getNextUri() != null && !queryResults.getStats().getState().equals(QueryState.RUNNING.toString())) {
            request = Request.Builder.prepareGet().setHeader("X-Presto-User", "user").setUri(queryResults.getNextUri()).build();
            queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        }
        return queryResults.getId();
    }

    private List<BasicQueryInfo> getQueryInfos(String path) {
        Request request = Request.Builder.prepareGet().setUri(this.server.resolve(path)).setHeader("X-Presto-User", "unknown").build();
        return (List)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(BasicQueryInfo.class)));
    }

    private static void assertStateCounts(Iterable<BasicQueryInfo> infos, int expectedFinished, int expectedFailed, int expectedRunning) {
        int failed = 0;
        int finished = 0;
        int running = 0;
        block5: for (BasicQueryInfo info : infos) {
            switch (info.getState()) {
                case FINISHED: {
                    ++finished;
                    continue block5;
                }
                case FAILED: {
                    ++failed;
                    continue block5;
                }
                case RUNNING: {
                    ++running;
                    continue block5;
                }
            }
            org.testng.Assert.fail((String)("Unexpected query state " + info.getState()));
        }
        Assert.assertEquals((int)failed, (int)expectedFailed);
        Assert.assertEquals((int)finished, (int)expectedFinished);
        Assert.assertEquals((int)running, (int)expectedRunning);
    }

    private QueryInfo getQueryInfo(String queryId) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").appendPath(queryId).addParameter("pretty", new String[]{"true"}).build();
        Request request = Request.Builder.prepareGet().setUri(uri).setHeader("X-Presto-User", "unknown").build();
        JsonCodec codec = (JsonCodec)this.server.getInstance(Key.get((TypeLiteral)new TypeLiteral<JsonCodec<QueryInfo>>(){}));
        return (QueryInfo)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)codec));
    }

    private int cancelQueryInfo(String queryId) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").appendPath(queryId).build();
        Request request = Request.Builder.prepareDelete().setUri(uri).setHeader("X-Presto-User", "unknown").build();
        return ((StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
    }

    private int killQueryInfo(String queryId, String kind) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").appendPath(queryId).appendPath(kind).build();
        Request request = Request.Builder.preparePut().setUri(uri).setHeader("X-Presto-User", "unknown").build();
        return ((StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
    }
}

