/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.server.ServerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestServerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ServerConfig)ConfigAssertions.recordDefaults(ServerConfig.class)).setCoordinator(true).setIncludeExceptionInResponse(true).setGracePeriod(new Duration(2.0, TimeUnit.MINUTES)).setEnhancedErrorReporting(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"coordinator", (Object)"false").put((Object)"http.include-exception-in-response", (Object)"false").put((Object)"shutdown.grace-period", (Object)"5m").put((Object)"sql.parser.enhanced-error-reporting", (Object)"false").build();
        ServerConfig expected = new ServerConfig().setCoordinator(false).setIncludeExceptionInResponse(false).setGracePeriod(new Duration(5.0, TimeUnit.MINUTES)).setEnhancedErrorReporting(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

