/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.protocol;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.client.ClientTypeSignature;
import io.prestosql.client.Column;
import io.prestosql.server.protocol.QueryResultRows;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.TestingSession;
import io.prestosql.tests.BogusType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class TestQueryResultRows {
    private static final Function<String, Column> BOOLEAN_COLUMN = name -> new Column(name, "boolean", new ClientTypeSignature("boolean"));
    private static final Function<String, Column> BIGINT_COLUMN = name -> new Column(name, "bigint", new ClientTypeSignature("bigint"));
    private static final Function<String, Column> INT_COLUMN = name -> new Column(name, "integer", new ClientTypeSignature("integer"));

    @Test
    public void shouldNotReturnValues() {
        QueryResultRows rows = QueryResultRows.empty((Session)TestQueryResultRows.getSession());
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isEmpty();
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(0);
        Assertions.assertThat((Optional)rows.getColumns()).isEmpty();
        Assertions.assertThat((boolean)rows.iterator().hasNext()).isFalse();
    }

    @Test
    public void shouldReturnSingleValue() {
        Column column = BOOLEAN_COLUMN.apply("_col0");
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withSingleBooleanValue(column, true).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(1)).containsOnly((Object[])new List[]{ImmutableList.of((Object)true)});
        Assertions.assertThat((List)((List)rows.getColumns().orElseThrow())).containsOnly((Object[])new Column[]{column});
        Assertions.assertThat((boolean)rows.iterator().hasNext()).isFalse();
    }

    @Test
    public void shouldReturnUpdateCount() {
        Column column = BIGINT_COLUMN.apply("_col0");
        long value = 10123L;
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)ImmutableList.of((Object)column), (List)ImmutableList.of((Object)BigintType.BIGINT)).addPages(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(value).build()).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        Assertions.assertThat((Optional)rows.getUpdateCount()).isPresent();
        Assertions.assertThat((Long)((Long)rows.getUpdateCount().get())).isEqualTo(value);
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).containsExactly((Object[])new List[]{ImmutableList.of((Object)value)});
        Assertions.assertThat((List)((List)rows.getColumns().orElseThrow())).containsOnly((Object[])new Column[]{column});
        Assertions.assertThat((Iterator)rows.iterator()).isExhausted();
    }

    @Test
    public void shouldNotHaveUpdateCount() {
        Column column = BOOLEAN_COLUMN.apply("_col0");
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withSingleBooleanValue(column, false).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        Assertions.assertThat((Optional)rows.getUpdateCount()).isEmpty();
        Assertions.assertThat((Iterator)rows.iterator()).hasNext();
    }

    @Test
    public void shouldReadAllValuesFromMultiplePages() {
        ImmutableList columns = ImmutableList.of((Object)INT_COLUMN.apply("_col0"), (Object)BIGINT_COLUMN.apply("_col1"));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, 10L).row(1, 11L).row(2, 12L).row(3, 13L).row(4, 14L).pageBreak().row(100, 110L).row(101, 111L).row(102, 112L).row(103, 113L).row(104, 114L).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).addPages(pages).withExceptionConsumer((Consumer)exceptionConsumer).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(10L);
        Assertions.assertThat((Optional)rows.getColumns()).isEqualTo(Optional.of(columns));
        Assertions.assertThat((Optional)rows.getUpdateCount()).isEmpty();
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)10L), ImmutableList.of((Object)1, (Object)11L), ImmutableList.of((Object)2, (Object)12L), ImmutableList.of((Object)3, (Object)13L), ImmutableList.of((Object)4, (Object)14L), ImmutableList.of((Object)100, (Object)110L), ImmutableList.of((Object)101, (Object)111L), ImmutableList.of((Object)102, (Object)112L), ImmutableList.of((Object)103, (Object)113L), ImmutableList.of((Object)104, (Object)114L)});
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
    }

    @Test
    public void shouldOmitBadRows() {
        ImmutableList columns = ImmutableList.of((Object)BOOLEAN_COLUMN.apply("_col0"), (Object)BOOLEAN_COLUMN.apply("_col1"));
        ImmutableList types = ImmutableList.of((Object)((Object)BogusType.BOGUS), (Object)((Object)BogusType.BOGUS));
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, 1).row(0, 0).row(0, 1).row(1, 0).row(0, 1).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(5L);
        Assertions.assertThat((Optional)rows.getColumns()).isEqualTo(Optional.of(columns));
        Assert.assertTrue((boolean)rows.getUpdateCount().isEmpty());
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)0)});
        List<Throwable> exceptions = exceptionConsumer.getExceptions();
        Assertions.assertThat(exceptions).isNotEmpty();
        Assertions.assertThat(exceptions).hasSize(4);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(0)).isInstanceOf(PrestoException.class)).hasMessage("Could not serialize column '_col1' of type 'Bogus' at position 1:2").hasRootCauseMessage("This is bogus exception");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(1)).isInstanceOf(PrestoException.class)).hasMessage("Could not serialize column '_col1' of type 'Bogus' at position 3:2").hasRootCauseMessage("This is bogus exception");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(2)).isInstanceOf(PrestoException.class)).hasMessage("Could not serialize column '_col0' of type 'Bogus' at position 4:1").hasRootCauseMessage("This is bogus exception");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(3)).isInstanceOf(PrestoException.class)).hasMessage("Could not serialize column '_col1' of type 'Bogus' at position 5:2").hasRootCauseMessage("This is bogus exception");
    }

    @Test
    public void shouldHandleNullValues() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "integer", new ClientTypeSignature("integer")), (Object)new Column("_col1", "boolean", new ClientTypeSignature("boolean")));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).pageBreak().row(1, null).pageBreak().row(2, true).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(3L);
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(3)).containsExactly((Object[])new List[]{Lists.newArrayList((Object[])new Object[]{0, null}), Lists.newArrayList((Object[])new Object[]{1, null}), Lists.newArrayList((Object[])new Object[]{2, true})});
    }

    @Test
    public void shouldHandleNullTimestamps() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "timestamp", new ClientTypeSignature("timestamp")), (Object)new Column("_col1", "timestamp with time zone", new ClientTypeSignature("timestamp with time zone")));
        ImmutableList types = ImmutableList.of((Object)TimestampType.TIMESTAMP, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(null, null).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(1L);
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(1)).containsExactly((Object[])new List[]{Lists.newArrayList((Object[])new Object[]{null, null})});
    }

    @Test
    public void shouldNotThrowWhenDataAndColumnsAreMissing() {
        QueryResultRows.empty((Session)TestQueryResultRows.getSession());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="columns and types size mismatch")
    public void shouldThrowWhenColumnsAndTypesSizeMismatch() {
        ImmutableList columns = ImmutableList.of((Object)INT_COLUMN.apply("_col0"));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).withColumnsAndTypes((List)columns, (List)types).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="columns and types must be present at the same time")
    public void shouldThrowWhenColumnsAreNull() {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).withColumnsAndTypes(null, (List)types).build();
    }

    @Test
    public void shouldAcceptNullColumnsAndTypes() {
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes(null, null).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="columns and types must be present at the same time")
    public void shouldThrowWhenTypesAreNull() {
        ImmutableList columns = ImmutableList.of((Object)INT_COLUMN.apply("_col0"));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).withColumnsAndTypes((List)columns, null).build();
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="data present without columns and types")
    public void shouldThrowWhenDataIsPresentWithoutColumns() {
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).build();
    }

    private static List<List<Object>> getAllValues(QueryResultRows rows) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List values : rows) {
            builder.add((Object)values);
        }
        return builder.build();
    }

    private static Session getSession() {
        return TestingSession.testSessionBuilder().build();
    }

    private static final class TestExceptionConsumer
    implements Consumer<Throwable> {
        private List<Throwable> exceptions = new ArrayList<Throwable>();

        private TestExceptionConsumer() {
        }

        @Override
        public void accept(Throwable throwable) {
            this.exceptions.add(throwable);
        }

        public List<Throwable> getExceptions() {
            return this.exceptions;
        }
    }
}

