/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Key;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerInfo;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.prestosql.client.OkHttpUtil;
import io.prestosql.plugin.base.security.AllowAllSystemAccessControl;
import io.prestosql.security.AccessControlManager;
import io.prestosql.server.security.PasswordAuthenticatorManager;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.testing.assertions.Assert;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class TestResourceSecurity {
    private static final String LOCALHOST_KEYSTORE = Resources.getResource((String)"cert/localhost.pem").getPath();
    private static final ImmutableMap<String, String> SECURE_PROPERTIES = ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").build();
    private static final String TEST_USER = "test-user";
    private static final String TEST_PASSWORD = "test-password";
    private static final String MANAGEMENT_USER = "management-user";
    private static final String MANAGEMENT_PASSWORD = "management-password";
    private static final String HMAC_KEY = Resources.getResource((String)"hmac_key.txt").getPath();
    private OkHttpClient client;

    @BeforeClass
    public void setup() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false);
        OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty());
        this.client = clientBuilder.build();
    }

    @Test
    public void testInsecureAuthenticatorHttp() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().build();){
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
        }
    }

    @Test
    public void testInsecureAuthenticatorHttps() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties(SECURE_PROPERTIES).build();){
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
            this.assertInsecureAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testInsecureAuthenticatorHttpsOnly() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").build()).build();){
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertInsecureAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testPasswordAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestResourceSecurity::authenticate);
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testPasswordAuthenticatorWithInsecureHttp() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestResourceSecurity::authenticate);
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttpInsecureEnabledOnly() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"management.user", (Object)MANAGEMENT_USER).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestResourceSecurity::authenticate);
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertFixedManagementUser(httpServerInfo.getHttpUri(), true);
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttpInsecureDisabledOnly() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").put((Object)"management.user", (Object)MANAGEMENT_USER).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestResourceSecurity::authenticate);
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getPublicLocation(httpServerInfo.getHttpUri()), 200);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(httpServerInfo.getHttpUri()), 403, TEST_USER, null);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(httpServerInfo.getHttpUri()), 200);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(httpServerInfo.getHttpUri()), 200, "unknown", "something");
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttps() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"management.user", (Object)MANAGEMENT_USER).put((Object)"management.user.https-enabled", (Object)"true").build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestResourceSecurity::authenticate);
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertFixedManagementUser(httpServerInfo.getHttpUri(), true);
            this.assertFixedManagementUser(httpServerInfo.getHttpsUri(), false);
        }
    }

    @Test
    public void testCertAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"certificate").put((Object)"http-server.https.truststore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.truststore.key", (Object)"").build()).build();){
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty());
            OkHttpClient clientWithCert = clientBuilder.build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithCert);
        }
    }

    @Test
    public void testJwtAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)HMAC_KEY).build()).build();){
            ((AccessControlManager)server.getInstance(Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            String hmac = Files.readString(Paths.get(HMAC_KEY, new String[0]));
            String token = Jwts.builder().signWith(SignatureAlgorithm.HS256, hmac).setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithJwt);
        }
    }

    private void assertInsecureAuthentication(URI baseUri) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER, MANAGEMENT_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", null);
    }

    private void assertPasswordAuthentication(URI baseUri) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER, "invalid");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER, "invalid");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER, "invalid");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER, MANAGEMENT_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER, TEST_PASSWORD);
    }

    private static void assertAuthenticationAutomatic(URI baseUri, OkHttpClient authorizedClient) throws IOException {
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getPublicLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getManagementLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getManagementLocation(baseUri), 200, Headers.of((String[])new String[]{"X-Presto-User", MANAGEMENT_USER}));
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getInternalLocation(baseUri), 403);
    }

    private void assertAuthenticationDisabled(URI baseUri) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, TEST_USER, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER, TEST_PASSWORD);
    }

    private void assertFixedManagementUser(URI baseUri, boolean insecureAuthentication) throws IOException {
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getPublicLocation(baseUri), 200);
        if (insecureAuthentication) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER, null);
        } else {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER, TEST_PASSWORD);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, "unknown", "something");
    }

    private static void assertOk(OkHttpClient client, String url) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, 200, null, null);
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, expectedCode, null, null);
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode, String userName, String password) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, expectedCode, Headers.of((String[])new String[]{"Authorization", Credentials.basic((String)((String)MoreObjects.firstNonNull((Object)userName, (Object)"")), (String)((String)MoreObjects.firstNonNull((Object)password, (Object)"")))}));
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).headers(headers).build();
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)expectedCode, (String)url);
        }
    }

    private static String getInternalLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/task");
    }

    private static String getManagementLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/node");
    }

    private static String getAuthorizedUserLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/query");
    }

    private static String getPublicLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/info");
    }

    private static String getLocation(URI baseUri, String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).toString();
    }

    private static Principal authenticate(String user, String password) {
        if (TEST_USER.equals(user) && TEST_PASSWORD.equals(password) || MANAGEMENT_USER.equals(user) && MANAGEMENT_PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static class TestSystemAccessControl
    extends AllowAllSystemAccessControl {
        private TestSystemAccessControl() {
        }

        public void checkCanReadSystemInformation(SystemSecurityContext context) {
            if (!context.getIdentity().getUser().equals(TestResourceSecurity.MANAGEMENT_USER)) {
                AccessDeniedException.denyReadSystemInformationAccess();
            }
        }
    }
}

