/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.prestosql.server.security.UserMapping;
import io.prestosql.server.security.UserMappingException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestUserMapping {
    private File testFile;

    @BeforeClass
    public void setUp() throws URISyntaxException {
        this.testFile = new File(Resources.getResource((String)"user-mapping.json").toURI());
    }

    @Test
    public void testStaticFactory() throws Exception {
        UserMapping defaultUserMapping = UserMapping.createUserMapping(Optional.empty(), Optional.empty());
        Assert.assertEquals((String)defaultUserMapping.mapUser("test@example.com"), (String)"test@example.com");
        UserMapping singlePatternUserMapping = UserMapping.createUserMapping(Optional.of("(.*?)@.*"), Optional.empty());
        Assert.assertEquals((String)singlePatternUserMapping.mapUser("test@example.com"), (String)"test");
        UserMapping fileUserMapping = UserMapping.createUserMapping(Optional.empty(), Optional.of(this.testFile));
        Assert.assertEquals((String)fileUserMapping.mapUser("test@example.com"), (String)"test_file");
        Assert.assertEquals((String)fileUserMapping.mapUser("user"), (String)"user");
        Assert.assertThrows(UserMappingException.class, () -> fileUserMapping.mapUser("test"));
        Assert.assertThrows(IllegalArgumentException.class, () -> UserMapping.createUserMapping(Optional.of("(.*?)@.*"), Optional.of(this.testFile)));
    }

    @Test
    public void testSimplePatternRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*")));
        Assert.assertEquals((String)userMapping.mapUser("test@example.com"), (String)"test");
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("no at sign"));
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("@no user string"));
    }

    @Test
    public void testReplacePatternRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "$1 ^ $1", true)));
        Assert.assertEquals((String)userMapping.mapUser("test@example.com"), (String)"test ^ test");
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("no at sign"));
        UserMapping emptyMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "  ", true)));
        Assert.assertThrows(UserMappingException.class, () -> emptyMapping.mapUser("test@example.com"));
    }

    @Test
    public void testNotAllowedRule() {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "$1", false)));
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("test@example.com"));
        UserMapping emptyMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "", false)));
        Assert.assertThrows(UserMappingException.class, () -> emptyMapping.mapUser("test@example.com"));
    }

    @Test
    public void testMultipleRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("test@example.com", "", false), (Object)new UserMapping.Rule("(.*?)@example.com")));
        Assert.assertEquals((String)userMapping.mapUser("apple@example.com"), (String)"apple");
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("test@example.com"));
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("apple@other.example.com"));
    }

    @Test
    public void testDocsExample() throws Exception {
        File docExample = new File("../presto-docs/src/main/sphinx/security/user-mapping.json");
        UserMapping userMapping = UserMapping.createUserMapping(Optional.empty(), Optional.of(docExample));
        Assert.assertEquals((String)userMapping.mapUser("apple@example.com"), (String)"apple");
        Assert.assertEquals((String)userMapping.mapUser("apple@uk.example.com"), (String)"apple_uk");
        Assert.assertEquals((String)userMapping.mapUser("apple@de.example.com"), (String)"apple_de");
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("apple@unknown.com"));
        Assert.assertThrows(UserMappingException.class, () -> userMapping.mapUser("test@example.com"));
    }
}

