/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.ParsingUtil;
import io.prestosql.sql.analyzer.ExpressionAnalyzer;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.DesugarArrayConstructorRewriter;
import io.prestosql.sql.planner.DesugarLikeRewriter;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.transaction.TestingTransactionManager;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.Map;
import org.testng.internal.EclipseInterface;

public final class ExpressionTestUtils {
    private static final SqlParser SQL_PARSER = new SqlParser();

    private ExpressionTestUtils() {
    }

    public static QualifiedName getFunctionName(FunctionCall actual) {
        return ResolvedFunction.fromQualifiedName((QualifiedName)actual.getName()).map(ResolvedFunction::getSignature).map(Signature::getName).map(QualifiedName::of).orElse(actual.getName());
    }

    public static void assertExpressionEquals(Expression actual, Expression expected) {
        ExpressionTestUtils.assertExpressionEquals(actual, expected, new SymbolAliases());
    }

    public static void assertExpressionEquals(Expression actual, Expression expected, SymbolAliases symbolAliases) {
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        if (!((Boolean)verifier.process((Node)actual, expected)).booleanValue()) {
            ExpressionTestUtils.failNotEqual(actual, expected, null);
        }
    }

    private static void failNotEqual(Object actual, Object expected, String message) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        throw new AssertionError((Object)((String)formatted + EclipseInterface.ASSERT_LEFT + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT));
    }

    public static Expression createExpression(Session session, String expression, Metadata metadata, TypeProvider symbolTypes) {
        Expression parsedExpression = SQL_PARSER.createExpression(expression, ParsingUtil.createParsingOptions((Session)session));
        return ExpressionTestUtils.planExpression(metadata, session, symbolTypes, parsedExpression);
    }

    public static Expression createExpression(String expression, Metadata metadata, TypeProvider symbolTypes) {
        return ExpressionTestUtils.createExpression(SessionTestUtils.TEST_SESSION, expression, metadata, symbolTypes);
    }

    public static Expression planExpression(Metadata metadata, Session session, TypeProvider typeProvider, Expression expression) {
        return (Expression)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(session, transactionSession -> {
            Expression rewritten = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)expression);
            rewritten = DesugarLikeRewriter.rewrite((Expression)rewritten, (Session)transactionSession, (Metadata)metadata, (TypeAnalyzer)new TypeAnalyzer(SQL_PARSER, metadata), (TypeProvider)typeProvider);
            rewritten = DesugarArrayConstructorRewriter.rewrite((Expression)rewritten, (Session)transactionSession, (Metadata)metadata, (TypeAnalyzer)new TypeAnalyzer(SQL_PARSER, metadata), (TypeProvider)typeProvider);
            rewritten = CanonicalizeExpressionRewriter.rewrite((Expression)rewritten, (Session)transactionSession, (Metadata)metadata, (TypeAnalyzer)new TypeAnalyzer(SQL_PARSER, metadata), (TypeProvider)typeProvider);
            return ExpressionTestUtils.resolveFunctionCalls(metadata, transactionSession, typeProvider, rewritten);
        });
    }

    public static Expression resolveFunctionCalls(Metadata metadata, Session session, TypeProvider typeProvider, Expression expression) {
        final ExpressionAnalyzer analyzer = ExpressionAnalyzer.createWithoutSubqueries((Metadata)metadata, (AccessControl)new AllowAllAccessControl(), (Session)session, (TypeProvider)typeProvider, (Map)ImmutableMap.of(), node -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)node, (String)"Constant expression cannot contain a subquery", (Object[])new Object[0]), (WarningCollector)WarningCollector.NOOP, (boolean)false);
        analyzer.analyze(expression, Scope.builder().build());
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                ResolvedFunction resolvedFunction = (ResolvedFunction)analyzer.getResolvedFunctions().get(NodeRef.of((Node)node));
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                FunctionCall newFunctionCall = new FunctionCall(rewritten.getLocation(), resolvedFunction.toQualifiedName(), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getArguments());
                return this.coerceIfNecessary((Expression)node, (Expression)newFunctionCall);
            }

            protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                rewrittenExpression = this.coerceIfNecessary(node, rewrittenExpression);
                return rewrittenExpression;
            }

            private Expression coerceIfNecessary(Expression originalExpression, Expression rewrittenExpression) {
                Type coercion = (Type)analyzer.getExpressionCoercions().get(NodeRef.of((Node)originalExpression));
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, TypeSignatureTranslator.toSqlType((Type)coercion), false, analyzer.getTypeOnlyCoercions().contains(NodeRef.of((Node)originalExpression)));
                }
                return rewrittenExpression;
            }
        }, (Expression)expression);
    }

    public static Map<NodeRef<Expression>, Type> getTypes(Session session, Metadata metadata, TypeProvider typeProvider, Expression expression) {
        return (Map)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(session, transactionSession -> new TypeAnalyzer(SQL_PARSER, metadata).getTypes(transactionSession, typeProvider, expression));
    }
}

