/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.IntArrayBlock;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.optimizer.ExpressionOptimizer;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.JsonType;
import io.prestosql.util.StructuralTestUtil;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExpressionOptimizer {
    private Metadata metadata;
    private ExpressionOptimizer optimizer;

    @BeforeClass
    public void setUp() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.optimizer = new ExpressionOptimizer(this.metadata, SessionTestUtils.TEST_SESSION);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.optimizer = null;
    }

    @Test(timeOut=10000L)
    public void testPossibleExponentialOptimizationTime() {
        ConstantExpression expression = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            expression = new CallExpression(this.metadata.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)expression, (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)));
        }
        this.optimizer.optimize((RowExpression)expression);
    }

    @Test
    public void testIfConstantOptimization() {
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant(null, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        CallExpression condition = new CallExpression(this.metadata.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)condition, 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
    }

    @Test
    public void testCastWithJsonParseOptimization() {
        ResolvedFunction jsonParseFunction = this.metadata.resolveFunction(QualifiedName.of((String)"json_parse"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        ResolvedFunction jsonCastFunction = this.metadata.getCoercion((Type)JsonType.JSON, (Type)new ArrayType((Type)IntegerType.INTEGER));
        CallExpression jsonCastExpression = new CallExpression(jsonCastFunction, (Type)new ArrayType((Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)jsonParseFunction, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.constant((Object)Slices.utf8Slice((String)"[1, 2]"), (Type)VarcharType.VARCHAR)})));
        RowExpression resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assertions.assertInstanceOf((Object)resultExpression, ConstantExpression.class);
        Object resultValue = ((ConstantExpression)resultExpression).getValue();
        Assertions.assertInstanceOf((Object)resultValue, IntArrayBlock.class);
        Assert.assertEquals(BlockAssertions.toValues((Type)IntegerType.INTEGER, (Block)((IntArrayBlock)resultValue)), (Collection)ImmutableList.of((Object)1, (Object)2));
        this.testCastWithJsonParseOptimization(jsonParseFunction, (Type)new ArrayType((Type)VarcharType.VARCHAR), "$internal$json_string_to_array_cast");
        this.testCastWithJsonParseOptimization(jsonParseFunction, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), "$internal$json_string_to_map_cast");
        this.testCastWithJsonParseOptimization(jsonParseFunction, (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), "$internal$json_string_to_row_cast");
    }

    private void testCastWithJsonParseOptimization(ResolvedFunction jsonParseFunction, Type targetType, String jsonStringToRowName) {
        ResolvedFunction jsonCastFunction = this.metadata.getCoercion((Type)JsonType.JSON, targetType);
        CallExpression jsonCastExpression = new CallExpression(jsonCastFunction, targetType, (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)jsonParseFunction, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        RowExpression resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((ResolvedFunction)this.metadata.getCoercion(QualifiedName.of((String)jsonStringToRowName), (Type)VarcharType.VARCHAR, targetType), (Type)targetType, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
    }

    private static RowExpression ifExpression(RowExpression condition, long trueValue, long falseValue) {
        return new SpecialForm(SpecialForm.Form.IF, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)condition, (Object)Expressions.constant((Object)trueValue, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)falseValue, (Type)BigintType.BIGINT)));
    }
}

