/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.JoniRegexp;
import io.prestosql.type.LikeFunctions;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLikeFunctions
extends AbstractTestFunctions {
    private static Slice offsetHeapSlice(String value) {
        Slice source = Slices.utf8Slice((String)value);
        Slice result = Slices.allocate((int)(source.length() + 5));
        result.setBytes(2, source);
        return result.slice(2, source.length());
    }

    @Test
    public void testLikeBasic() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"f%b__"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foobar"), (JoniRegexp)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (JoniRegexp)regex));
        this.assertFunction("'foob' LIKE 'f%b__'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foob' LIKE 'f%b'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testLikeChar() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"f%b__"));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foobar"), (JoniRegexp)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (JoniRegexp)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foob"), (JoniRegexp)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (JoniRegexp)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeChar((Long)7L, (Slice)Slices.utf8Slice((String)"foob"), (JoniRegexp)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeChar((Long)7L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (JoniRegexp)regex));
        this.assertFunction("cast('foob' as char(6)) LIKE 'f%b__'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foob' as char(7)) LIKE 'f%b__'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLikeSpacesInPattern() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"ala  "));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala  "), (JoniRegexp)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala"), (JoniRegexp)regex));
        regex = LikeFunctions.likePattern((Long)5L, (Slice)Slices.utf8Slice((String)"ala"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala  "), (JoniRegexp)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala"), (JoniRegexp)regex));
    }

    @Test
    public void testLikeNewlineInPattern() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"%o\nbar"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (JoniRegexp)regex));
    }

    @Test
    public void testLikeNewlineBeforeMatch() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"%b%"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (JoniRegexp)regex));
    }

    @Test
    public void testLikeNewlineInMatch() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"f%b%"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (JoniRegexp)regex));
    }

    @Test(timeOut=1000L)
    public void testLikeUtf8Pattern() {
        JoniRegexp regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%\u540d\u8a89%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo"), (JoniRegexp)regex));
    }

    @Test(timeOut=1000L)
    public void testLikeInvalidUtf8Value() {
        Slice value = Slices.wrappedBuffer((byte[])new byte[]{97, 98, 99, -1, 120, 121});
        JoniRegexp regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)value, (JoniRegexp)regex));
    }

    @Test
    public void testBackslashesNoSpecialTreatment() {
        JoniRegexp regex = LikeFunctions.compileLikePattern((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"), (JoniRegexp)regex));
    }

    @Test
    public void testSelfEscaping() {
        JoniRegexp regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\\\abc\\%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc%"), (JoniRegexp)regex));
    }

    @Test
    public void testAlternateEscapedCharacters() {
        JoniRegexp regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"xxx%x_abcxx"), (Slice)Slices.utf8Slice((String)"x"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"x%_abcx"), (JoniRegexp)regex));
    }

    @Test
    public void testInvalidLikePattern() {
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"#"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#abc"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#"), (Slice)Slices.utf8Slice((String)"#")));
    }

    @Test
    public void testIsLikePattern() {
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc"), Optional.empty()));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#_def"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc##def"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#%def"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc%def"), Optional.empty()));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef_"), Optional.empty()));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef##_"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"%abcdef#_"), Optional.of(Slices.utf8Slice((String)"#"))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(PrestoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#abc"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(PrestoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(PrestoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testPatternConstantPrefixBytes() {
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc"), Optional.empty()), (int)3);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#_def"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc##def"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#%def"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc%def"), Optional.empty()), (int)3);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abcdef_"), Optional.empty()), (int)6);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abcdef##_"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"%abcdef#_"), Optional.of(Slices.utf8Slice((String)"#"))), (int)0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(PrestoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#abc"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(PrestoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(PrestoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testUnescapeValidLikePattern() {
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc"), Optional.empty()), (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc#_"), Optional.of(Slices.utf8Slice((String)"#"))), (Object)Slices.utf8Slice((String)"abc_"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a##bc#_"), Optional.of(Slices.utf8Slice((String)"#"))), (Object)Slices.utf8Slice((String)"a#bc_"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a###_bc"), Optional.of(Slices.utf8Slice((String)"#"))), (Object)Slices.utf8Slice((String)"a#_bc"));
    }
}

