/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.informationschema.InformationSchemaConnector;
import io.prestosql.connector.system.SystemConnector;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.memory.MemoryManagerConfig;
import io.prestosql.memory.NodeMemoryConfig;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.InMemoryNodeManager;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.operator.scalar.ApplyFunction;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlConfig;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Statement;
import io.prestosql.testing.TestingEventListenerManager;
import io.prestosql.testing.TestingMetadata;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAnalyzer {
    private static final String TPCH_CATALOG = "tpch";
    private static final CatalogName TPCH_CATALOG_NAME = new CatalogName("tpch");
    private static final String SECOND_CATALOG = "c2";
    private static final CatalogName SECOND_CATALOG_NAME = new CatalogName("c2");
    private static final String THIRD_CATALOG = "c3";
    private static final CatalogName THIRD_CATALOG_NAME = new CatalogName("c3");
    private static final String CATALOG_FOR_IDENTIFIER_CHAIN_TESTS = "cat";
    private static final CatalogName CATALOG_FOR_IDENTIFIER_CHAIN_TESTS_NAME = new CatalogName("cat");
    private static final Session SETUP_SESSION = TestingSession.testSessionBuilder().setCatalog("c1").setSchema("s1").build();
    private static final Session CLIENT_SESSION = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("s1").build();
    private static final Session CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS = TestingSession.testSessionBuilder().setCatalog("cat").setSchema("a").build();
    private static final SqlParser SQL_PARSER = new SqlParser();
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;

    @Test
    public void testTooManyArguments() {
        this.assertFails("SELECT greatest(" + Joiner.on((String)", ").join(Collections.nCopies(128, "rand()")) + ")").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS);
    }

    @Test
    public void testNonComparableGroupBy() {
        this.assertFails("SELECT * FROM (SELECT approx_set(1)) GROUP BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testNonComparableWindowPartition() {
        this.assertFails("SELECT row_number() OVER (PARTITION BY t.x) FROM (VALUES(CAST (NULL AS HyperLogLog))) AS t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testNonComparableWindowOrder() {
        this.assertFails("SELECT row_number() OVER (ORDER BY t.x) FROM (VALUES(color('red'))) AS t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testNonComparableDistinctAggregation() {
        this.assertFails("SELECT count(DISTINCT x) FROM (SELECT approx_set(1) x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testNonComparableDistinct() {
        this.assertFails("SELECT DISTINCT * FROM (SELECT approx_set(1) x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT DISTINCT x FROM (SELECT approx_set(1) x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT DISTINCT ROW(1, approx_set(1)).* from t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testInSubqueryTypes() {
        this.assertFails("SELECT * FROM (VALUES 'a') t(y) WHERE y IN (VALUES 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT (VALUES true) IN (VALUES 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testScalarSubQuery() {
        this.analyze("SELECT 'a', (VALUES 1) GROUP BY 1");
        this.analyze("SELECT 'a', (SELECT (1))");
        this.analyze("SELECT * FROM t1 WHERE (VALUES 1) = 2");
        this.analyze("SELECT * FROM t1 WHERE (VALUES 1) IN (VALUES 1)");
        this.analyze("SELECT * FROM t1 WHERE (VALUES 1) IN (2)");
        this.analyze("SELECT * FROM (SELECT 1) t1(x) WHERE x IN (SELECT 1)");
    }

    @Test
    public void testRowDereferenceInCorrelatedSubquery() {
        this.assertFails("WITH     t(b) AS (VALUES row(cast(row(1) AS row(a bigint)))),    u(b) AS (VALUES row(cast(row(1, 1) AS row(a bigint, b bigint))))SELECT b FROM t WHERE EXISTS (    SELECT b.a    FROM u    GROUP BY b.b)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:171: 'b.a' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testReferenceToOutputColumnFromOrderByAggregation() {
        this.assertFails("SELECT max(a) AS a FROM (values (1,2)) t(a,b) GROUP BY b ORDER BY max(a+b)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("line 1:71: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT DISTINCT a AS a, max(a) AS c from (VALUES (1, 2)) t(a, b) GROUP BY a ORDER BY max(a)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("line 1:90: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS a FROM (values (1,2)) t(a,b) GROUP BY b ORDER BY MAX(a.someField)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("line 1:102: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT 1 AS x FROM (values (1,2)) t(x, y) GROUP BY y ORDER BY sum(apply(1, z -> x))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("line 1:81: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT row_number() over() as a from (values (41, 42), (-41, -42)) t(a,b) group by a+b order by a+b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("\\Qline 1:98: '(a + b)' must be an aggregate expression or appear in GROUP BY clause\\E");
    }

    @Test
    public void testHavingReferencesOutputAlias() {
        this.assertFails("SELECT sum(a) x FROM t1 HAVING x > 5").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
    }

    @Test
    public void testSelectAllColumns() {
        this.assertFails("SELECT *").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
        this.assertFails("SELECT foo.* FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.assertFails("SELECT a.b.c.d.* FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.assertFails("SELECT (1, 2).* AS (a) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES);
        this.assertFails("SELECT non_row.* FROM (VALUES ('true', 1)) t(non_row, b)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.assertFails("SELECT t.row.non_row.* FROM (VALUES (CAST(ROW('true') AS ROW(non_row boolean)), 1)) t(row, b)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT (SELECT outer_relation.* FROM (VALUES 1) inner_relation) FROM (values 2) outer_relation").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testGroupByWithWildcard() {
        this.assertFails("SELECT * FROM t1 GROUP BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT u1.*, u2.* FROM (select a, b + 1 from t1) u1 JOIN (select a, b + 2 from t1) u2 ON u1.a = u2.a GROUP BY u1.a, u2.a, 3").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
    }

    @Test
    public void testAsteriskedIdentifierChainResolution() {
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.b.* FROM a.b, t1 AS a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM a.b, t1 AS a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT cat.a.b.* FROM cat.a.b, t2 AS cat").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT cat.a.b.* FROM (VALUES 1) v) FROM cat.a.b, t2 AS cat").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM a.b) FROM t1 AS a");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM t5 AS a) FROM a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM t5 AS a");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM b, t1");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.t1.b.* FROM a.t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT alias.b.* FROM a.t1 as alias");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT cat.a.t1.b.* FROM cat.a.t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT alias.b.* FROM cat.a.t1 AS alias");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT t3.b.f1.* FROM t3");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT t4.b.f1.f11.* FROM t4");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM cat.a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.b.* FROM cat.a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM a.b");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.b.* FROM t4 AS a, t5 AS a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM t4 AS a, t5 AS a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
    }

    @Test
    public void testGroupByInvalidOrdinal() {
        this.assertFails("SELECT * FROM t1 GROUP BY 10").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
        this.assertFails("SELECT * FROM t1 GROUP BY 0").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
    }

    @Test
    public void testGroupByWithSubquerySelectExpression() {
        this.analyze("SELECT (SELECT t1.a) FROM t1 GROUP BY a");
        this.analyze("SELECT (SELECT a) FROM t1 GROUP BY t1.a");
        this.analyze("SELECT (SELECT u.a FROM (values 1) u(a)) FROM t1 u GROUP BY b");
        this.assertFails("SELECT (SELECT u.a from (values 1) x(a)) FROM t1 u GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:16: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT a+2) FROM t1 GROUP BY a+1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:16: Subquery uses 'a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT 1 FROM t1 WHERE a = u.a) FROM t1 u GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:36: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT a as a) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.analyze("SELECT (SELECT 1 FROM t1 u WHERE a = u.a) FROM t1 u GROUP BY b");
    }

    @Test
    public void testGroupByWithExistsSelectExpression() {
        this.analyze("SELECT EXISTS(SELECT t1.a) FROM t1 GROUP BY a");
        this.analyze("SELECT EXISTS(SELECT a) FROM t1 GROUP BY t1.a");
        this.analyze("SELECT EXISTS(SELECT u.a FROM (values 1) u(a)) FROM t1 u GROUP BY b");
        this.assertFails("SELECT EXISTS(SELECT u.a from (values 1) x(a)) FROM t1 u GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:22: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT EXISTS(SELECT a+2) FROM t1 GROUP BY a+1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:22: Subquery uses 'a' which must appear in GROUP BY clause");
        this.assertFails("SELECT EXISTS(SELECT 1 FROM t1 WHERE a = u.a) FROM t1 u GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:42: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT EXISTS(SELECT a as a) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.analyze("SELECT EXISTS(SELECT 1 FROM t1 u WHERE a = u.a) FROM t1 u GROUP BY b");
    }

    @Test
    public void testGroupByWithSubquerySelectExpressionWithDereferenceExpression() {
        this.analyze("SELECT (SELECT t.a.someField) FROM (VALUES ROW(CAST(ROW(1) AS ROW(someField BIGINT)), 2)) t(a, b) GROUP BY a");
        this.assertFails("SELECT (SELECT t.a.someField) FROM (VALUES ROW(CAST(ROW(1) AS ROW(someField BIGINT)), 2)) t(a, b) GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:16: Subquery uses 't.a' which must appear in GROUP BY clause");
    }

    @Test
    public void testOrderByInvalidOrdinal() {
        this.assertFails("SELECT * FROM t1 ORDER BY 10").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
        this.assertFails("SELECT * FROM t1 ORDER BY 0").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
    }

    @Test
    public void testOrderByNonComparable() {
        this.assertFails("SELECT x FROM (SELECT approx_set(1) x) ORDER BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM (SELECT approx_set(1) x) ORDER BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT x FROM (SELECT approx_set(1) x) ORDER BY x").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testOffsetInvalidRowCount() {
        this.assertFails("SELECT * FROM t1 OFFSET 987654321098765432109876543210 ROWS").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testFetchFirstInvalidRowCount() {
        this.assertFails("SELECT * FROM t1 FETCH FIRST 987654321098765432109876543210 ROWS ONLY").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM t1 FETCH FIRST 0 ROWS ONLY").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    @Test
    public void testFetchFirstWithTiesMissingOrderBy() {
        this.assertFails("SELECT * FROM t1 FETCH FIRST 5 ROWS WITH TIES").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY);
        this.assertFails("SELECT * FROM (SELECT * FROM (values 1, 3, 2) t(a) ORDER BY a) FETCH FIRST 5 ROWS WITH TIES").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY);
    }

    @Test
    public void testLimitInvalidRowCount() {
        this.assertFails("SELECT * FROM t1 LIMIT 987654321098765432109876543210").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testNestedAggregation() {
        this.assertFails("SELECT sum(count(*)) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NESTED_AGGREGATION);
    }

    @Test
    public void testAggregationsNotAllowed() {
        this.assertFails("SELECT * FROM t1 WHERE sum(a) > 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT * FROM t1 GROUP BY sum(a)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT * FROM t1 JOIN t2 ON sum(t1.a) = t2.a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
    }

    @Test
    public void testWindowsNotAllowed() {
        this.assertFails("SELECT * FROM t1 WHERE foo() over () > 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT * FROM t1 GROUP BY rank() over ()").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT * FROM t1 JOIN t2 ON sum(t1.a) over () = t2.a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT 1 FROM (VALUES 1) HAVING count(*) OVER () > 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW);
    }

    @Test
    public void testGrouping() {
        this.analyze("SELECT a, b, sum(c), grouping(a, b) FROM t1 GROUP BY GROUPING SETS ((a), (a, b))");
        this.analyze("SELECT grouping(t1.a) FROM t1 GROUP BY a");
        this.analyze("SELECT grouping(b) FROM t1 GROUP BY t1.b");
        this.analyze("SELECT grouping(a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a) FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupingNotAllowed() {
        this.assertFails("SELECT a, b, sum(c) FROM t1 WHERE grouping(a, b) GROUP BY GROUPING SETS ((a), (a, b))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT a, b, sum(c) FROM t1 GROUP BY grouping(a, b)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT t1.a, t1.b FROM t1 JOIN t2 ON grouping(t1.a, t1.b) > t2.a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR);
        this.assertFails("SELECT grouping(a) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_GROUP_BY);
        this.assertFails("SELECT * FROM t1 ORDER BY grouping(a)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_GROUP_BY);
        this.assertFails("SELECT grouping(a) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS);
        this.assertFails("SELECT grouping(a.field) FROM (VALUES ROW(CAST(ROW(1) AS ROW(field BIGINT)))) t(a) GROUP BY a.field").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS);
        this.assertFails("SELECT a FROM t1 GROUP BY a ORDER BY grouping(a)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS);
    }

    @Test
    public void testGroupingTooManyArguments() {
        String grouping = "GROUPING(a, a, a, a, a, a, a, a, a, a, a, a, a, a, a,a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a,a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a,a, a)";
        this.assertFails(String.format("SELECT a, b, %s + 1 FROM t1 GROUP BY GROUPING SETS ((a), (a, b))", grouping)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS);
        this.assertFails(String.format("SELECT a, b, %s as g FROM t1 GROUP BY a, b HAVING g > 0", grouping)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS);
        this.assertFails(String.format("SELECT a, b, rank() OVER (PARTITION BY %s) FROM t1 GROUP BY GROUPING SETS ((a), (a, b))", grouping)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS);
        this.assertFails(String.format("SELECT a, b, rank() OVER (PARTITION BY a ORDER BY %s) FROM t1 GROUP BY GROUPING SETS ((a), (a, b))", grouping)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS);
    }

    @Test
    public void testInvalidTable() {
        this.assertFails("SELECT * FROM foo.bar.t").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND);
        this.assertFails("SELECT * FROM foo.t").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND);
        this.assertFails("SELECT * FROM foo").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
    }

    @Test
    public void testInvalidSchema() {
        this.assertFails("SHOW TABLES FROM NONEXISTENT_SCHEMA").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND);
        this.assertFails("SHOW TABLES IN NONEXISTENT_SCHEMA LIKE '%'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND);
    }

    @Test
    public void testNonAggregate() {
        this.assertFails("SELECT 'a', array[b][1] FROM t1 GROUP BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT a, sum(b) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT sum(b) / a FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT sum(b) / a FROM t1 GROUP BY c").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT sum(b) FROM t1 ORDER BY a + 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT a, sum(b) FROM t1 GROUP BY a HAVING c > 5").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT count(*) over (PARTITION BY a) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT count(*) over (ORDER BY a) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT count(*) over (ORDER BY count(*) ROWS a PRECEDING) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT count(*) over (ORDER BY count(*) ROWS BETWEEN b PRECEDING AND a PRECEDING) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT count(*) over (ORDER BY count(*) ROWS BETWEEN a PRECEDING AND UNBOUNDED PRECEDING) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
    }

    @Test
    public void testInvalidAttribute() {
        this.assertFails("SELECT f FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
        this.assertFails("SELECT * FROM t1 ORDER BY f").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
        this.assertFails("SELECT count(*) FROM t1 GROUP BY f").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
        this.assertFails("SELECT * FROM t1 WHERE f > 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
    }

    @Test
    public void testInvalidAttributeCorrectErrorMessage() {
        this.assertFails("SELECT t.y FROM (VALUES 1) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("\\Qline 1:8: Column 't.y' cannot be resolved\\E");
    }

    @Test
    public void testOrderByMustAppearInSelectWithDistinct() {
        this.assertFails("SELECT DISTINCT a FROM t1 ORDER BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT);
    }

    @Test
    public void testNonDeterministicOrderBy() {
        this.analyze("SELECT DISTINCT random() as b FROM t1 ORDER BY b");
        this.analyze("SELECT random() FROM t1 ORDER BY random()");
        this.analyze("SELECT a FROM t1 ORDER BY random()");
        this.assertFails("SELECT DISTINCT random() FROM t1 ORDER BY random()").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT);
    }

    @Test
    public void testNonBooleanWhereClause() {
        this.assertFails("SELECT * FROM t1 WHERE a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testDistinctAggregations() {
        this.analyze("SELECT COUNT(DISTINCT a), SUM(a) FROM t1");
    }

    @Test
    public void testMultipleDistinctAggregations() {
        this.analyze("SELECT COUNT(DISTINCT a), COUNT(DISTINCT b) FROM t1");
    }

    @Test
    public void testOrderByExpressionOnOutputColumn() {
        this.analyze("SELECT a x FROM t1 ORDER BY x + 1");
        this.analyze("SELECT max(a) FROM (values (1,2), (2,1)) t(a,b) GROUP BY b ORDER BY max(b*1e0)");
        this.analyze("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS a FROM (values (1,2)) t(a,b) GROUP BY b ORDER BY a.someField");
        this.analyze("SELECT 1 AS x FROM (values (1,2)) t(x, y) GROUP BY y ORDER BY sum(apply(1, x -> x))");
    }

    @Test
    public void testOrderByExpressionOnOutputColumn2() {
        this.analyze("SELECT a x FROM t1 ORDER BY a + 1");
        this.assertFails("SELECT x.c as x\nFROM (VALUES 1) x(c)\nORDER BY x.c").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH).hasLocation(3, 10);
    }

    @Test
    public void testOrderByWithWildcard() {
        this.analyze("SELECT t1.* FROM t1 ORDER BY a");
    }

    @Test
    public void testOrderByWithGroupByAndSubquerySelectExpression() {
        this.analyze("SELECT a FROM t1 GROUP BY a ORDER BY (SELECT a)");
        this.assertFails("SELECT a FROM t1 GROUP BY a ORDER BY (SELECT b)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:46: Subquery uses 'b' which must appear in GROUP BY clause");
        this.analyze("SELECT a AS b FROM t1 GROUP BY t1.a ORDER BY (SELECT b)");
        this.assertFails("SELECT a AS b FROM t1 GROUP BY t1.a \nORDER BY MAX((SELECT b))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("line 2:22: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.analyze("SELECT a FROM t1 GROUP BY a ORDER BY MAX((SELECT x FROM (VALUES 4) t(x)))");
        this.analyze("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS x\nFROM (VALUES (1, 2)) t(a, b)\nGROUP BY b\nORDER BY (SELECT x.someField)");
        this.assertFails("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS x\nFROM (VALUES (1, 2)) t(a, b)\nGROUP BY b\nORDER BY MAX((SELECT x.someField))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching("line 4:22: Invalid reference to output projection attribute from ORDER BY aggregation");
    }

    @Test
    public void testTooManyGroupingElements() {
        Session session = TestingSession.testSessionBuilder((SessionPropertyManager)new SessionPropertyManager(new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig().setMaxGroupingSets(2048), new NodeMemoryConfig()))).build();
        this.analyze(session, "SELECT a, b, c, d, e, f, g, h, i, j, k, SUM(l)FROM (VALUES (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))\nt (a, b, c, d, e, f, g, h, i, j, k, l)\nGROUP BY CUBE (a, b, c, d, e, f), CUBE (g, h, i, j, k)");
        this.assertFails(session, "SELECT a, b, c, d, e, f, g, h, i, j, k, l, SUM(m)FROM (VALUES (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))\nt (a, b, c, d, e, f, g, h, i, j, k, l, m)\nGROUP BY CUBE (a, b, c, d, e, f), CUBE (g, h, i, j, k, l)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_GROUPING_SETS).hasMessageMatching("line 3:10: GROUP BY has 4096 grouping sets but can contain at most 2048");
        this.assertFails(session, "SELECT a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, x, w, y, z, aa, ab, ac, ad, ae, SUM(af)FROM (VALUES (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32))\nt (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, x, w, y, z, aa, ab, ac, ad, ae, af)\nGROUP BY CUBE (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, x, w, y, z, aa, ab, ac, ad, ae)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_GROUPING_SETS).hasMessageMatching(String.format("line 3:10: GROUP BY has more than %s grouping sets but can contain at most 2048", Integer.MAX_VALUE));
    }

    @Test
    public void testMismatchedColumnAliasCount() {
        this.assertFails("SELECT * FROM t1 u (x, y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES);
    }

    @Test
    public void testJoinOnConstantExpression() {
        this.analyze("SELECT * FROM t1 JOIN t2 ON 1 = 1");
    }

    @Test
    public void testJoinOnNonBooleanExpression() {
        this.assertFails("SELECT * FROM t1 JOIN t2 ON 5").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testJoinOnAmbiguousName() {
        this.assertFails("SELECT * FROM t1 JOIN t2 ON a = a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
    }

    @Test
    public void testNonEquiOuterJoin() {
        this.analyze("SELECT * FROM t1 LEFT JOIN t2 ON t1.a + t2.a = 1");
        this.analyze("SELECT * FROM t1 RIGHT JOIN t2 ON t1.a + t2.a = 1");
        this.analyze("SELECT * FROM t1 LEFT JOIN t2 ON t1.a = t2.a OR t1.b = t2.b");
    }

    @Test
    public void testNonBooleanHaving() {
        this.assertFails("SELECT sum(a) FROM t1 HAVING sum(a)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testAmbiguousReferenceInOrderBy() {
        this.assertFails("SELECT a x, b x FROM t1 ORDER BY x").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.assertFails("SELECT a x, a x FROM t1 ORDER BY x").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
        this.assertFails("SELECT a, a FROM t1 ORDER BY a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME);
    }

    @Test
    public void testImplicitCrossJoin() {
        this.analyze("SELECT * FROM t1, t2");
    }

    @Test
    public void testNaturalJoinNotSupported() {
        this.assertFails("SELECT * FROM t1 NATURAL JOIN t2").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testNestedWindowFunctions() {
        this.assertFails("SELECT avg(sum(a) OVER ()) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW);
        this.assertFails("SELECT sum(sum(a) OVER ()) OVER () FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW);
        this.assertFails("SELECT avg(a) OVER (PARTITION BY sum(b) OVER ()) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW);
        this.assertFails("SELECT avg(a) OVER (ORDER BY sum(b) OVER ()) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW);
    }

    @Test
    public void testWindowAttributesForLagLeadFunctions() {
        this.assertFails("SELECT lag(x, 2) OVER() FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY);
        this.assertFails("SELECT lag(x, 2) OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
    }

    @Test
    public void testWindowFunctionWithoutOverClause() {
        this.assertFails("SELECT row_number()").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_OVER);
        this.assertFails("SELECT coalesce(lead(a), 0) from (values(0)) t(a)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_OVER);
    }

    @Test
    public void testInvalidWindowFrame() {
        this.assertFails("SELECT rank() OVER (ROWS UNBOUNDED FOLLOWING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS 2 FOLLOWING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN UNBOUNDED FOLLOWING AND CURRENT ROW)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND 5 PRECEDING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN 2 FOLLOWING AND 5 PRECEDING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN 2 FOLLOWING AND CURRENT ROW)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (RANGE 2 PRECEDING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (RANGE BETWEEN 2 PRECEDING AND CURRENT ROW)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (RANGE BETWEEN CURRENT ROW AND 5 FOLLOWING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (RANGE BETWEEN 2 PRECEDING AND 5 FOLLOWING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME);
        this.assertFails("SELECT rank() OVER (ROWS 5e-1 PRECEDING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT rank() OVER (ROWS 'foo' PRECEDING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND 5e-1 FOLLOWING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT rank() OVER (ROWS BETWEEN CURRENT ROW AND 'foo' FOLLOWING)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testDistinctInWindowFunctionParameter() {
        this.assertFails("SELECT a, count(DISTINCT b) OVER () FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testGroupByOrdinalsWithWildcard() {
        this.analyze("SELECT t1.*, a FROM t1 GROUP BY 1,2,c,d");
    }

    @Test
    public void testGroupByWithQualifiedName() {
        this.analyze("SELECT a FROM t1 GROUP BY t1.a");
    }

    @Test
    public void testGroupByWithQualifiedName2() {
        this.analyze("SELECT t1.a FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupByWithQualifiedName3() {
        this.analyze("SELECT * FROM t1 GROUP BY t1.a, t1.b, t1.c, t1.d");
    }

    @Test
    public void testGroupByWithRowExpression() {
        this.analyze("SELECT (a, b) FROM t1 GROUP BY a, b");
    }

    @Test
    public void testHaving() {
        this.analyze("SELECT sum(a) FROM t1 HAVING avg(a) - avg(b) > 10");
        this.assertFails("SELECT a FROM t1 HAVING a = 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:8: 'a' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testWithCaseInsensitiveResolution() {
        this.analyze("WITH AB AS (SELECT * FROM t1) SELECT * FROM ab");
    }

    @Test
    public void testStartTransaction() {
        this.analyze("START TRANSACTION");
        this.analyze("START TRANSACTION ISOLATION LEVEL READ UNCOMMITTED");
        this.analyze("START TRANSACTION ISOLATION LEVEL READ COMMITTED");
        this.analyze("START TRANSACTION ISOLATION LEVEL REPEATABLE READ");
        this.analyze("START TRANSACTION ISOLATION LEVEL SERIALIZABLE");
        this.analyze("START TRANSACTION READ ONLY");
        this.analyze("START TRANSACTION READ WRITE");
        this.analyze("START TRANSACTION ISOLATION LEVEL READ COMMITTED, READ ONLY");
        this.analyze("START TRANSACTION READ ONLY, ISOLATION LEVEL READ COMMITTED");
        this.analyze("START TRANSACTION READ WRITE, ISOLATION LEVEL SERIALIZABLE");
    }

    @Test
    public void testCommit() {
        this.analyze("COMMIT");
        this.analyze("COMMIT WORK");
    }

    @Test
    public void testRollback() {
        this.analyze("ROLLBACK");
        this.analyze("ROLLBACK WORK");
    }

    @Test
    public void testExplainAnalyze() {
        this.analyze("EXPLAIN ANALYZE SELECT * FROM t1");
    }

    @Test
    public void testInsert() {
        this.assertFails("INSERT INTO t6 (a) SELECT b from t6").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.analyze("INSERT INTO t1 SELECT * FROM t1");
        this.analyze("INSERT INTO t3 SELECT * FROM t3");
        this.analyze("INSERT INTO t3 SELECT a, b FROM t3");
        this.assertFails("INSERT INTO t1 VALUES (1, 2)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.analyze("INSERT INTO t5 (a) VALUES(null)");
        this.analyze("INSERT INTO t5 VALUES (1)");
        this.assertFails("INSERT INTO t5 VALUES (1, 2)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.analyze("INSERT INTO t6 (a) SELECT a from t6");
        this.analyze("INSERT INTO t6 (a) SELECT c from t6");
        this.analyze("INSERT INTO t6 (a,b,c,d) SELECT * from t6");
        this.analyze("INSERT INTO t6 (A,B,C,D) SELECT * from t6");
        this.analyze("INSERT INTO t6 (a,b,c,d) SELECT d,b,c,a from t6");
        this.assertFails("INSERT INTO t6 (a) SELECT b from t6").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t6 (unknown) SELECT * FROM t6").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
        this.assertFails("INSERT INTO t6 (a, a) SELECT * FROM t6").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME);
        this.assertFails("INSERT INTO t6 (a, A) SELECT * FROM t6").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME);
        this.analyze("INSERT INTO t7 (b) SELECT (a) FROM t7 ");
        this.analyze("INSERT INTO t7 (a) SELECT (b) FROM t7");
        this.analyze("INSERT INTO t7 (d) SELECT (c) FROM t7 ");
        this.analyze("INSERT INTO t7 (c) SELECT (d) FROM t7 ");
        this.analyze("INSERT INTO t7 (d) VALUES (ARRAY[null])");
        this.analyze("INSERT INTO t6 (d) VALUES (1), (2), (3)");
        this.analyze("INSERT INTO t6 (a,b,c,d) VALUES (1, 'a', 1, 1), (2, 'b', 2, 2), (3, 'c', 3, 3), (4, 'd', 4, 4)");
        this.analyze("INSERT INTO t8 (tinyint_column, integer_column, decimal_column, real_column) VALUES (1e0, 1e0, 1e0, 1e0)");
        this.analyze("INSERT INTO t8 (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (CAST('aa     ' AS varchar), CAST('aa     ' AS varchar), CAST('aa     ' AS varchar))");
        this.analyze("INSERT INTO t8 (tinyint_array_column) SELECT (bigint_array_column) FROM t8");
        this.analyze("INSERT INTO t8 (row_column) VALUES (ROW(ROW(1e0, CAST('aa     ' AS varchar))))");
        this.analyze("INSERT INTO t8 (date_column) VALUES (TIMESTAMP '2019-11-18 22:13:40')");
        this.assertFails("INSERT INTO t8 (integer_column) VALUES ('text')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t8 (integer_column) VALUES (true)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t8 (integer_column) VALUES (ROW(ROW(1e0)))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t8 (integer_column) VALUES (TIMESTAMP '2019-11-18 22:13:40')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t8 (unbounded_varchar_column) VALUES (1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t8 (nested_bounded_varchar_column) VALUES (ROW(ROW(CAST('aa' AS varchar(10)))))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testInvalidInsert() {
        this.assertFails("INSERT INTO foo VALUES (1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.assertFails("INSERT INTO v1 VALUES (1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("INSERT INTO t1 (a) VALUES (1), (1, 2)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t1 (a, b) VALUES (1), (1, 2)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t1 (a, b) VALUES (1, 2), (1, 2), (1, 2, 3)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t1 (a, b) VALUES ('a', 'b'), ('a', 'b', 'c')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t1 (a, b) VALUES ('a', 'b'), (1, 'b')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("INSERT INTO t1 (a, b) VALUES ('a', 'b'), ('a', 'b'), (1, 'b')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testDuplicateWithQuery() {
        this.assertFails("WITH a AS (SELECT * FROM t1),     a AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_NAMED_QUERY);
    }

    @Test
    public void testCaseInsensitiveDuplicateWithQuery() {
        this.assertFails("WITH a AS (SELECT * FROM t1),     A AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_NAMED_QUERY);
    }

    @Test
    public void testWithForwardReference() {
        this.assertFails("WITH a AS (SELECT * FROM b),     b AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
    }

    @Test
    public void testExpressions() {
        this.assertFails("SELECT NOT 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 AND TRUE FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT TRUE AND 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 OR TRUE FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT TRUE OR 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 = 'a' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT NULLIF(1, 'a') FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CASE WHEN TRUE THEN 'a' ELSE 1 END FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CASE WHEN '1' THEN 1 ELSE 2 END FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CASE 1 WHEN 'a' THEN 2 END FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CASE 1 WHEN 1 THEN 2 ELSE 'a' END FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT COALESCE(1, 'a') FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CAST(date '2014-01-01' AS bigint)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT TRY_CAST(date '2014-01-01' AS bigint)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CAST(null AS UNKNOWN)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CAST(1 AS MAP)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CAST(1 AS ARRAY)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT CAST(1 AS ROW)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT -'a' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT +'a' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 'a' + 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 + 'a'  FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 'a' - 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 - 'a' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 LIKE 'a' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 'a' LIKE 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 'a' LIKE 'b' ESCAPE 1 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT EXTRACT(DAY FROM 'a') FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 BETWEEN 'a' AND 2 FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 BETWEEN 0 AND 'b' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 BETWEEN 'a' AND 'b' FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM t1 WHERE 1 IN ('a')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM t1 WHERE 'a' IN (1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM t1 WHERE 'a' IN (1, 'b')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT t.x.f1 FROM (VALUES 1) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT x.f1 FROM (VALUES 1) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT ROW(1, 'a')[x]").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT).hasMessageMatching("line 1:20: Subscript expression on ROW requires a constant index");
        this.assertFails("SELECT ROW(1, 'a')[9999999999]").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH).hasMessageMatching("line 1:20: Subscript expression on ROW requires integer index, found bigint");
        this.assertFails("SELECT ROW(1, 'a')[-1]").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT).hasMessageMatching("line 1:20: Invalid subscript index: -1. ROW indices start at 1");
        this.assertFails("SELECT ROW(1, 'a')[0]").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT).hasMessageMatching("line 1:20: Invalid subscript index: 0. ROW indices start at 1");
        this.assertFails("SELECT ROW(1, 'a')[5]").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT).hasMessageMatching("line 1:20: Subscript index out of bounds: 5, max value is 2");
    }

    @Test
    public void testLike() {
        this.analyze("SELECT '1' LIKE '1'");
        this.analyze("SELECT CAST('1' as CHAR(1)) LIKE '1'");
    }

    @Test(enabled=false)
    public void testInWithNumericTypes() {
        this.analyze("SELECT * FROM t1 WHERE 1 IN (1, 2, 3.5)");
    }

    @Test
    public void testWildcardWithoutFrom() {
        this.assertFails("SELECT *").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
    }

    @Test
    public void testReferenceWithoutFrom() {
        this.assertFails("SELECT dummy").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
    }

    @Test
    public void testGroupBy() {
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupByEmpty() {
        this.assertFails("SELECT a FROM t1 GROUP BY ()").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
    }

    @Test
    public void testComplexExpressionInGroupingSet() {
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY ROLLUP(x + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE).hasMessageMatching("\\Qline 1:49: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY CUBE(x + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE).hasMessageMatching("\\Qline 1:47: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY GROUPING SETS (x + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE).hasMessageMatching("\\Qline 1:57: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY ROLLUP(x, x + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE).hasMessageMatching("\\Qline 1:52: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY CUBE(x, x + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE).hasMessageMatching("\\Qline 1:50: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY GROUPING SETS (x, x + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE).hasMessageMatching("\\Qline 1:60: GROUP BY expression must be a column reference: (x + 1)\\E");
    }

    @Test
    public void testSingleGroupingSet() {
        this.analyze("SELECT SUM(b) FROM t1 GROUP BY ()");
        this.analyze("SELECT SUM(b) FROM t1 GROUP BY GROUPING SETS (())");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS (a)");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS (a)");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b))");
    }

    @Test
    public void testMultipleGroupingSetMultipleColumns() {
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b), (c, d))");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY a, b, GROUPING SETS ((c, d))");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a), (c, d))");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b)), ROLLUP (c, d)");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b)), CUBE (c, d)");
    }

    @Test
    public void testAggregateWithWildcard() {
        this.assertFails("SELECT * FROM (SELECT a + 1, b FROM t1) t GROUP BY b ORDER BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("Column 1 not in GROUP BY clause");
        this.assertFails("SELECT * FROM (SELECT a, b FROM t1) t GROUP BY b ORDER BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("Column 't.a' not in GROUP BY clause");
        this.assertFails("SELECT * FROM (SELECT a, b FROM t1) GROUP BY b ORDER BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("Column 'a' not in GROUP BY clause");
        this.assertFails("SELECT * FROM (SELECT a + 1, b FROM t1) GROUP BY b ORDER BY 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("Column 1 not in GROUP BY clause");
    }

    @Test
    public void testGroupByCase() {
        this.assertFails("SELECT CASE a WHEN 1 THEN 'a' ELSE 'b' END, count(*) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT CASE 1 WHEN 2 THEN a ELSE 0 END, count(*) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT CASE 1 WHEN 2 THEN 0 ELSE a END, count(*) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT CASE WHEN a = 1 THEN 'a' ELSE 'b' END, count(*) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT CASE WHEN true THEN a ELSE 0 END, count(*) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT CASE WHEN true THEN 0 ELSE a END, count(*) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
    }

    @Test
    public void testGroupingWithWrongColumnsAndNoGroupBy() {
        this.assertFails("SELECT a, SUM(b), GROUPING(a, b, c, d) FROM t1 GROUP BY GROUPING SETS ((a, b), (c))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS);
        this.assertFails("SELECT a, SUM(b), GROUPING(a, b) FROM t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_GROUP_BY);
    }

    @Test
    public void testMismatchedUnionQueries() {
        this.assertFails("SELECT 1 UNION SELECT 'a'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT a FROM t1 UNION SELECT 'a'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("(SELECT 1) UNION SELECT 'a'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1, 2 UNION SELECT 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 'a' UNION SELECT 'b', 'c'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("TABLE t2 UNION SELECT 'a'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 123, 'foo' UNION ALL SELECT 'bar', 999").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH).hasMessageMatching(".* column 1 in UNION query has incompatible types.*");
        this.assertFails("SELECT 123, 123 UNION ALL SELECT 999, 'bar'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH).hasMessageMatching(".* column 2 in UNION query has incompatible types.*");
    }

    @Test
    public void testUnionUnmatchedOrderByAttribute() {
        this.assertFails("TABLE t2 UNION ALL SELECT c, d FROM t1 ORDER BY c").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
    }

    @Test
    public void testGroupByComplexExpressions() {
        this.assertFails("SELECT IF(a IS NULL, 1, 0) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT IF(a IS NOT NULL, 1, 0) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT IF(CAST(a AS VARCHAR) LIKE 'a', 1, 0) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT a IN (1, 2, 3) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
        this.assertFails("SELECT 1 IN (a, 2, 3) FROM t1 GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE);
    }

    @Test
    public void testNonNumericTableSamplePercentage() {
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI ('a')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI (a + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT);
    }

    @Test
    public void testTableSampleOutOfRange() {
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI (-1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI (-101)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    @Test
    public void testCreateTableAsColumns() {
        this.analyze("CREATE TABLE test(a) AS SELECT 123");
        this.analyze("CREATE TABLE test(a, b) AS SELECT 1, 2");
        this.analyze("CREATE TABLE test(a) AS (VALUES 1)");
        this.assertFails("CREATE TABLE test AS SELECT 123").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_COLUMN_NAME);
        this.assertFails("CREATE TABLE test AS SELECT 1 a, 2 a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME);
        this.assertFails("CREATE TABLE test AS SELECT null a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN);
        this.assertFails("CREATE TABLE test(x) AS SELECT 1, 2").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES).hasLocation(1, 19);
        this.assertFails("CREATE TABLE test(x, y) AS SELECT 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES).hasLocation(1, 19);
        this.assertFails("CREATE TABLE test(x, y) AS (VALUES 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES).hasLocation(1, 19);
        this.assertFails("CREATE TABLE test(abc, AbC) AS SELECT 1, 2").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME).hasLocation(1, 24);
        this.assertFails("CREATE TABLE test(x) AS SELECT null").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN).hasLocation(1, 1);
        this.assertFails("CREATE TABLE test(x) WITH (p1 = y) AS SELECT null").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching(".*Column 'y' cannot be resolved");
        this.assertFails("CREATE TABLE test(x) WITH (p1 = 'p1', p2 = 'p2', p1 = 'p3') AS SELECT null").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("CREATE TABLE test(x) WITH (p1 = 'p1', \"p1\" = 'p2') AS SELECT null").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testCreateTable() {
        this.analyze("CREATE TABLE test (id bigint)");
        this.analyze("CREATE TABLE test (id bigint) WITH (p1 = 'p1')");
        this.assertFails("CREATE TABLE test (x bigint) WITH (p1 = y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching(".*Column 'y' cannot be resolved");
        this.assertFails("CREATE TABLE test (id bigint) WITH (p1 = 'p1', p2 = 'p2', p1 = 'p3')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("CREATE TABLE test (id bigint) WITH (p1 = 'p1', \"p1\" = 'p2')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testAnalyze() {
        this.analyze("ANALYZE t1");
        this.analyze("ANALYZE t1 WITH (p1 = 'p1')");
        this.assertFails("ANALYZE t1 WITH (p1 = 'p1', p2 = 2, p1 = 'p3')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("ANALYZE t1 WITH (p1 = 'p1', \"p1\" = 'p2')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testCreateSchema() {
        this.analyze("CREATE SCHEMA test");
        this.analyze("CREATE SCHEMA test WITH (p1 = 'p1')");
        this.assertFails("CREATE SCHEMA test WITH (p1 = y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND).hasMessageMatching(".*Column 'y' cannot be resolved");
        this.assertFails("CREATE SCHEMA test WITH (p1 = 'p1', p2 = 'p2', p1 = 'p3')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("CREATE SCHEMA test WITH (p1 = 'p1', \"p1\" = 'p2')").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testCreateViewColumns() {
        this.assertFails("CREATE VIEW test AS SELECT 123").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_COLUMN_NAME);
        this.assertFails("CREATE VIEW test AS SELECT 1 a, 2 a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME);
        this.assertFails("CREATE VIEW test AS SELECT null a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN);
    }

    @Test
    public void testCreateRecursiveView() {
        this.assertFails("CREATE OR REPLACE VIEW v1 AS SELECT * FROM v1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE);
    }

    @Test
    public void testExistingRecursiveView() {
        this.analyze("SELECT * FROM v1 a JOIN v1 b ON a.a = b.a");
        this.analyze("SELECT * FROM v1 a JOIN (SELECT * from v1) b ON a.a = b.a");
        this.assertFails("SELECT * FROM v5").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW);
    }

    @Test
    public void testShowCreateView() {
        this.analyze("SHOW CREATE VIEW v1");
        this.analyze("SHOW CREATE VIEW v2");
        this.assertFails("SHOW CREATE VIEW t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SHOW CREATE VIEW none").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
    }

    @Test
    public void testStaleView() {
        this.assertFails("SELECT * FROM v2").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_STALE);
    }

    @Test
    public void testStoredViewAnalysisScoping() {
        this.analyze("WITH t1 AS (SELECT 123 x) SELECT * FROM v1");
    }

    @Test
    public void testStoredViewResolution() {
        this.analyze("SELECT * FROM c3.s3.v3");
    }

    @Test
    public void testQualifiedViewColumnResolution() {
        this.analyze("SELECT v1.a FROM v1");
        this.analyze("SELECT s1.v1.a FROM s1.v1");
        this.analyze("SELECT tpch.s1.v1.a FROM tpch.s1.v1");
    }

    @Test
    public void testViewWithUppercaseColumn() {
        this.analyze("SELECT * FROM v4");
    }

    @Test
    public void testUse() {
        this.assertFails("USE foo").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testNotNullInJoinClause() {
        this.analyze("SELECT * FROM (VALUES (1)) a (x) JOIN (VALUES (2)) b ON a.x IS NOT NULL");
    }

    @Test
    public void testIfInJoinClause() {
        this.analyze("SELECT * FROM (VALUES (1)) a (x) JOIN (VALUES (2)) b ON IF(a.x = 1, true, false)");
    }

    @Test
    public void testLiteral() {
        this.assertFails("SELECT TIMESTAMP '2012-10-31 01:00:00 PT'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL);
    }

    @Test
    public void testLambda() {
        this.analyze("SELECT apply(5, x -> abs(x)) from t1");
        this.assertFails("SELECT x -> abs(x) from t1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testLambdaCapture() {
        this.analyze("SELECT apply(c1, x -> x + c2) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(c1, c2)");
        this.analyze("SELECT apply(c1 + 10, x -> apply(x + 100, y -> c1)) FROM (VALUES 1) t(c1)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 1000) t(x)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 'abc') t(x)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 1000) t(x)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 'abc') t(x)");
    }

    @Test
    public void testLambdaInAggregationContext() {
        this.analyze("SELECT apply(sum(x), i -> i * i) FROM (VALUES 1, 2, 3, 4, 5) t(x)");
        this.analyze("SELECT apply(x, i -> i - 1), sum(y) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) group by x");
        this.analyze("SELECT x, apply(sum(y), i -> i * 10) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) group by x");
        this.analyze("SELECT apply(8, x -> x + 1) FROM (VALUES (1, 2)) t(x,y) GROUP BY y");
        this.assertFails("SELECT apply(sum(x), i -> i * x) FROM (VALUES 1, 2, 3, 4, 5) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, y -> x) FROM (VALUES (1,2)) t(x,y) GROUP BY y").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, y -> x.someField) FROM (VALUES (CAST(ROW(1) AS ROW(someField BIGINT)), 2)) t(x,y) GROUP BY y").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.analyze("SELECT apply(CAST(ROW(1) AS ROW(someField BIGINT)), x -> x.someField) FROM (VALUES (1,2)) t(x,y) GROUP BY y");
        this.analyze("SELECT apply(sum(x), x -> x * x) FROM (VALUES 1, 2, 3, 4, 5) t(x)");
        this.analyze("SELECT apply(sum(x), x -> apply(x, x -> x * x)) FROM (VALUES 1, 2, 3, 4, 5) t(x)");
        this.assertFails("SELECT apply(sum(x), x -> x * x) + x FROM (VALUES 1, 2, 3, 4, 5) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(sum(x), x -> apply(x, x -> x * x)) + x FROM (VALUES 1, 2, 3, 4, 5) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, y -> x + y) FROM (VALUES (1,2)) t(x, y) GROUP BY x+y").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, x -> y + transform(array[1], z -> x)[1]) FROM (VALUES (1, 2)) t(x,y) GROUP BY y + transform(array[1], z -> x)[1]").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testLambdaInSubqueryContext() {
        this.analyze("SELECT apply(x, i -> i * i) FROM (SELECT 10 x)");
        this.analyze("SELECT apply((SELECT 10), i -> i * i)");
        this.analyze("SELECT apply(x, i -> i * x) FROM (SELECT 10 x)");
        this.analyze("SELECT apply(x, y -> y * x) FROM (SELECT 10 x, 3 y)");
        this.analyze("SELECT apply(x, z -> y * x) FROM (SELECT 10 x, 3 y)");
    }

    @Test
    public void testLambdaWithAggregationAndGrouping() {
        this.assertFails("SELECT transform(ARRAY[1], y -> max(x)) FROM (VALUES 10) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT apply(1, x -> max(x)) FROM (VALUES (1,2)) t(x,y) GROUP BY y").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT apply(CAST(ROW(1) AS ROW(someField BIGINT)), x -> max(x.someField)) FROM (VALUES (1,2)) t(x,y) GROUP BY y").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT apply(1, x -> grouping(x)) FROM (VALUES (1, 2)) t(x, y) GROUP BY y").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
    }

    @Test
    public void testLambdaWithSubquery() {
        this.assertFails("SELECT apply(1, i -> (SELECT 3)) FROM (VALUES 1) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessageMatching(".* Lambda expression cannot contain subqueries");
        this.assertFails("SELECT apply(1, i -> (SELECT i)) FROM (VALUES 1) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessageMatching(".* Lambda expression cannot contain subqueries");
        this.analyze("SELECT (SELECT apply(0, x -> x + b) FROM (VALUES 1) x(a)) FROM t1 u GROUP BY b");
        this.assertFails("SELECT (SELECT apply(0, x -> x + a) FROM (VALUES 1) x(c)) FROM t1 u GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:34: Subquery uses 'a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT apply(0, x -> x + u.a) from (values 1) x(a)) FROM t1 u GROUP BY b").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:34: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.analyze("SELECT (SELECT apply(0, x -> x + a) FROM (VALUES 1) x(a)) FROM t1 u GROUP BY b");
        this.analyze("SELECT (SELECT apply(0, a -> a + a)) FROM t1 u GROUP BY b");
    }

    @Test
    public void testLambdaWithSubqueryInOrderBy() {
        this.analyze("SELECT a FROM t1 ORDER BY (SELECT apply(0, x -> x + a))");
        this.analyze("SELECT a AS output_column FROM t1 ORDER BY (SELECT apply(0, x -> x + output_column))");
        this.analyze("SELECT count(*) FROM t1 GROUP BY a ORDER BY (SELECT apply(0, x -> x + a))");
        this.analyze("SELECT count(*) AS output_column FROM t1 GROUP BY a ORDER BY (SELECT apply(0, x -> x + output_column))");
        this.assertFails("SELECT count(*) FROM t1 GROUP BY a ORDER BY (SELECT apply(0, x -> x + b))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE).hasMessageMatching("line 1:71: Subquery uses 'b' which must appear in GROUP BY clause");
    }

    @Test
    public void testLambdaWithInvalidParameterCount() {
        this.assertFails("SELECT apply(5, (x, y) -> 6)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:17: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT apply(5, (x, y, z) -> 6)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:17: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT TRY(apply(5, (x, y) -> x + 1) / 0)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:21: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT TRY(apply(5, (x, y, z) -> x + 1) / 0)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:21: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT filter(ARRAY [5, 6], (x, y) -> x = 5)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:29: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT filter(ARRAY [5, 6], (x, y, z) -> x = 5)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:29: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT map_filter(map(ARRAY [5, 6], ARRAY [5, 6]), (x) -> x = 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:52: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT map_filter(map(ARRAY [5, 6], ARRAY [5, 6]), (x, y, z) -> x = y + z)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:52: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT reduce(ARRAY [5, 20], 0, (s) -> s, s -> s)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:33: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT reduce(ARRAY [5, 20], 0, (s, x, z) -> s + x, s -> s + z)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:33: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT transform(ARRAY [5, 6], (x, y) -> x + y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:32: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT transform(ARRAY [5, 6], (x, y, z) -> x + y + z)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:32: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT transform_keys(map(ARRAY[1], ARRAY [2]), k -> k)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:49: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT transform_keys(MAP(ARRAY['a'], ARRAY['b']), (k, v, x) -> k + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:52: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT transform_values(map(ARRAY[1], ARRAY [2]), k -> k)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:51: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT transform_values(map(ARRAY[1], ARRAY [2]), (k, v, x) -> k + 1)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:51: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT zip_with(ARRAY[1], ARRAY['a'], x -> x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:39: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT zip_with(ARRAY[1], ARRAY['a'], (x, y, z) -> (x, y, z))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE).hasMessageMatching("line 1:39: Expected a lambda that takes 2 argument\\(s\\) but got 3");
    }

    @Test
    public void testInvalidDelete() {
        this.assertFails("DELETE FROM foo").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND);
        this.assertFails("DELETE FROM v1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("DELETE FROM v1 WHERE a = 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testInvalidShowTables() {
        this.assertFails("SHOW TABLES FROM a.b.c").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR);
        Session session = TestingSession.testSessionBuilder().setCatalog(null).setSchema(null).build();
        this.assertFails(session, "SHOW TABLES").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME);
        this.assertFails(session, "SHOW TABLES FROM a").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME);
        this.assertFails(session, "SHOW TABLES FROM c2.unknown").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND);
        session = TestingSession.testSessionBuilder().setCatalog(SECOND_CATALOG).setSchema(null).build();
        this.assertFails(session, "SHOW TABLES").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.MISSING_SCHEMA_NAME);
        this.assertFails(session, "SHOW TABLES FROM unknown").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND);
    }

    @Test
    public void testInvalidAtTimeZone() {
        this.assertFails("SELECT 'abc' AT TIME ZONE 'America/Los_Angeles'").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testValidJoinOnClause() {
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON TRUE");
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON 1=1");
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON a.x=b.x AND a.y=b.y");
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON NULL");
    }

    @Test
    public void testInValidJoinOnClause() {
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON a.x + b.x").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON ROW (TRUE)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON (a.x=b.x, a.y=b.y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testInvalidAggregationFilter() {
        this.assertFails("SELECT sum(x) FILTER (WHERE x > 1) OVER (PARTITION BY x) FROM (VALUES (1), (2), (2), (4)) t (x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SELECT abs(x) FILTER (where y = 1) FROM (VALUES (1, 1)) t(x, y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE);
        this.assertFails("SELECT abs(x) FILTER (where y = 1) FROM (VALUES (1, 1, 1)) t(x, y, z) GROUP BY z").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE);
    }

    @Test
    public void testAggregationWithOrderBy() {
        this.analyze("SELECT array_agg(DISTINCT x ORDER BY x) FROM (VALUES (1, 2), (3, 4)) t(x, y)");
        this.analyze("SELECT array_agg(x ORDER BY y) FROM (VALUES (1, 2), (3, 4)) t(x, y)");
        this.assertFails("SELECT array_agg(DISTINCT x ORDER BY y) FROM (VALUES (1, 2), (3, 4)) t(x, y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT);
        this.assertFails("SELECT abs(x ORDER BY y) FROM (VALUES (1, 2), (3, 4)) t(x, y)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE);
        this.assertFails("SELECT array_agg(x ORDER BY x) FROM (VALUES MAP(ARRAY['a'], ARRAY['b'])) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT 1 as a, array_agg(x ORDER BY a) FROM (VALUES (1), (2), (3)) t(x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
        this.assertFails("SELECT 1 AS c FROM (VALUES (1), (2)) t(x) ORDER BY sum(x order by c)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND);
    }

    @Test
    public void testQuantifiedComparisonExpression() {
        this.analyze("SELECT * FROM t1 WHERE t1.a <= ALL (VALUES 10, 20)");
        this.assertFails("SELECT * FROM t1 WHERE t1.a = ANY (SELECT 1, 2)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SELECT * FROM t1 WHERE t1.a = SOME (VALUES ('abc'))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT map(ARRAY[1], ARRAY['hello']) < ALL (VALUES map(ARRAY[1], ARRAY['hello']))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.analyze("SELECT map(ARRAY[1], ARRAY['hello']) = ALL (VALUES map(ARRAY[1], ARRAY['hello']))");
        this.assertFails("SELECT cast(NULL AS HyperLogLog) < ALL (VALUES cast(NULL AS HyperLogLog))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT cast(NULL AS HyperLogLog) = ANY (VALUES cast(NULL AS HyperLogLog))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT cast(NULL AS qdigest(double)) < ALL (VALUES cast(NULL AS qdigest(double)))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
        this.assertFails("SELECT cast(NULL AS qdigest(double)) = ANY (VALUES cast(NULL AS qdigest(double)))").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH);
    }

    @Test
    public void testJoinUnnest() {
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) CROSS JOIN UNNEST(x)");
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN UNNEST(x) ON true");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN UNNEST(x) ON true").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN UNNEST(x) ON true").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
        this.analyze("SELECT * FROM (VALUES 1), UNNEST(array[2])");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT JOIN UNNEST(x) b(x) USING (x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT JOIN UNNEST(x) ON 1 = 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT JOIN UNNEST(x) ON false").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testJoinLateral() {
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) CROSS JOIN LATERAL(VALUES x)");
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN LATERAL(VALUES x) ON true");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN LATERAL(VALUES x) ON true").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN LATERAL(VALUES x) ON true").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE);
        this.analyze("SELECT * FROM (VALUES 1) FULL OUTER JOIN LATERAL(VALUES 2) ON true");
        this.assertFails("SELECT * FROM (VALUES 1) a(x) FULL OUTER JOIN LATERAL(VALUES 2) b(x) USING (x)").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SELECT * FROM (VALUES 1) FULL OUTER JOIN LATERAL(VALUES 2) ON 1 = 1").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        this.assertFails("SELECT * FROM (VALUES 1) FULL OUTER JOIN LATERAL(VALUES 2) ON false").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testNullTreatment() {
        this.assertFails("SELECT count() RESPECT NULLS OVER ()").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NULL_TREATMENT_NOT_ALLOWED);
        this.assertFails("SELECT count() IGNORE NULLS OVER ()").hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NULL_TREATMENT_NOT_ALLOWED);
        this.analyze("SELECT lag(1) RESPECT NULLS OVER (ORDER BY x) FROM (VALUES 1) t(x)");
        this.analyze("SELECT lag(1) IGNORE NULLS OVER (ORDER BY x) FROM (VALUES 1) t(x)");
    }

    @BeforeClass
    public void setup() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AccessControlManager(this.transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig());
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.metadata.addFunctions((List)ImmutableList.of((Object)ApplyFunction.APPLY_FUNCTION));
        Catalog tpchTestCatalog = this.createTestingCatalog(TPCH_CATALOG, TPCH_CATALOG_NAME);
        catalogManager.registerCatalog(tpchTestCatalog);
        this.metadata.getTablePropertyManager().addProperties(TPCH_CATALOG_NAME, tpchTestCatalog.getConnector(TPCH_CATALOG_NAME).getTableProperties());
        this.metadata.getAnalyzePropertyManager().addProperties(TPCH_CATALOG_NAME, tpchTestCatalog.getConnector(TPCH_CATALOG_NAME).getAnalyzeProperties());
        catalogManager.registerCatalog(this.createTestingCatalog(SECOND_CATALOG, SECOND_CATALOG_NAME));
        catalogManager.registerCatalog(this.createTestingCatalog(THIRD_CATALOG, THIRD_CATALOG_NAME));
        SchemaTableName table1 = new SchemaTableName("s1", "t1");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table1, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), false));
        SchemaTableName table2 = new SchemaTableName("s1", "t2");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table2, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), false));
        SchemaTableName table3 = new SchemaTableName("s1", "t3");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table3, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("x", (Type)BigintType.BIGINT, null, true))), false));
        SchemaTableName table4 = new SchemaTableName("s2", "t4");
        this.inSetupTransaction(session -> this.metadata.createTable(session, SECOND_CATALOG, new ConnectorTableMetadata(table4, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT))), false));
        SchemaTableName table5 = new SchemaTableName("s1", "t5");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table5, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT, null, true))), false));
        SchemaTableName table6 = new SchemaTableName("s1", "t6");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table6, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), false));
        SchemaTableName table7 = new SchemaTableName("s1", "t7");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table7, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)DoubleType.DOUBLE), (Object)new ColumnMetadata("c", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("d", (Type)new ArrayType((Type)DoubleType.DOUBLE)))), false));
        ConnectorViewDefinition viewData1 = new ConnectorViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("a", BigintType.BIGINT.getTypeId())), Optional.of("comment"), Optional.of("user"), false);
        this.inSetupTransaction(session -> this.metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v1"), viewData1, false));
        ConnectorViewDefinition viewData2 = new ConnectorViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("a", VarcharType.VARCHAR.getTypeId())), Optional.of("comment"), Optional.of("user"), false);
        this.inSetupTransaction(session -> this.metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v2"), viewData2, false));
        ConnectorViewDefinition viewData3 = new ConnectorViewDefinition("select a from t4", Optional.of(SECOND_CATALOG), Optional.of("s2"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("a", BigintType.BIGINT.getTypeId())), Optional.of("comment"), Optional.of("owner"), false);
        this.inSetupTransaction(session -> this.metadata.createView(session, new QualifiedObjectName(THIRD_CATALOG, "s3", "v3"), viewData3, false));
        ConnectorViewDefinition viewData4 = new ConnectorViewDefinition("select A from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("a", BigintType.BIGINT.getTypeId())), Optional.of("comment"), Optional.of("user"), false);
        this.inSetupTransaction(session -> this.metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v4"), viewData4, false));
        ConnectorViewDefinition viewData5 = new ConnectorViewDefinition("select * from v5", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("a", BigintType.BIGINT.getTypeId())), Optional.of("comment"), Optional.of("user"), false);
        this.inSetupTransaction(session -> this.metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v5"), viewData5, false));
        SchemaTableName table8 = new SchemaTableName("s1", "t8");
        this.inSetupTransaction(session -> this.metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table8, (List)ImmutableList.of((Object)new ColumnMetadata("tinyint_column", (Type)TinyintType.TINYINT), (Object)new ColumnMetadata("integer_column", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("decimal_column", (Type)DecimalType.createDecimalType((int)5, (int)3)), (Object)new ColumnMetadata("real_column", (Type)RealType.REAL), (Object)new ColumnMetadata("char_column", (Type)CharType.createCharType((long)3L)), (Object)new ColumnMetadata("bounded_varchar_column", (Type)VarcharType.createVarcharType((int)3)), (Object)new ColumnMetadata("unbounded_varchar_column", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("tinyint_array_column", (Type)new ArrayType((Type)TinyintType.TINYINT)), (Object)new ColumnMetadata("bigint_array_column", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("nested_bounded_varchar_column", (Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)3)})), (Object)new ColumnMetadata("row_column", (Type)RowType.anonymousRow((Type[])new Type[]{TinyintType.TINYINT, VarcharType.createUnboundedVarcharType()})), (Object)new ColumnMetadata("date_column", (Type)DateType.DATE), (Object[])new ColumnMetadata[0])), false));
        catalogManager.registerCatalog(this.createTestingCatalog(CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS_NAME));
        Type singleFieldRowType = this.metadata.fromSqlType("row(f1 bigint)");
        Type rowType = this.metadata.fromSqlType("row(f1 bigint, f2 bigint)");
        Type nestedRowType = this.metadata.fromSqlType("row(f1 row(f11 bigint, f12 bigint), f2 boolean)");
        Type doubleNestedRowType = this.metadata.fromSqlType("row(f1 row(f11 row(f111 bigint, f112 bigint), f12 boolean), f2 boolean)");
        SchemaTableName b = new SchemaTableName("a", "b");
        this.inSetupTransaction(session -> this.metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(b, (List)ImmutableList.of((Object)new ColumnMetadata("x", (Type)VarcharType.VARCHAR))), false));
        SchemaTableName t1 = new SchemaTableName("a", "t1");
        this.inSetupTransaction(session -> this.metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t1, (List)ImmutableList.of((Object)new ColumnMetadata("b", rowType))), false));
        SchemaTableName t2 = new SchemaTableName("a", "t2");
        this.inSetupTransaction(session -> this.metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t2, (List)ImmutableList.of((Object)new ColumnMetadata("a", rowType))), false));
        SchemaTableName t3 = new SchemaTableName("a", "t3");
        this.inSetupTransaction(session -> this.metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t3, (List)ImmutableList.of((Object)new ColumnMetadata("b", nestedRowType), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT))), false));
        SchemaTableName t4 = new SchemaTableName("a", "t4");
        this.inSetupTransaction(session -> this.metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t4, (List)ImmutableList.of((Object)new ColumnMetadata("b", doubleNestedRowType), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT))), false));
        SchemaTableName t5 = new SchemaTableName("a", "t5");
        this.inSetupTransaction(session -> this.metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t5, (List)ImmutableList.of((Object)new ColumnMetadata("b", singleFieldRowType))), false));
    }

    private void inSetupTransaction(Consumer<Session> consumer) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().execute(SETUP_SESSION, consumer);
    }

    private static Analyzer createAnalyzer(Session session, Metadata metadata) {
        return new Analyzer(session, metadata, SQL_PARSER, (AccessControl)new AllowAllAccessControl(), Optional.empty(), Collections.emptyList(), Collections.emptyMap(), WarningCollector.NOOP);
    }

    private void analyze(@Language(value="SQL") String query) {
        this.analyze(CLIENT_SESSION, query);
    }

    private void analyze(Session clientSession, @Language(value="SQL") String query) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().execute(clientSession, session -> {
            Analyzer analyzer = TestAnalyzer.createAnalyzer(session, this.metadata);
            Statement statement = SQL_PARSER.createStatement(query, new ParsingOptions());
            analyzer.analyze(statement);
        });
    }

    private PrestoExceptionAssert assertFails(Session session, @Language(value="SQL") String query) {
        return PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.analyze(session, query));
    }

    private PrestoExceptionAssert assertFails(@Language(value="SQL") String query) {
        return this.assertFails(CLIENT_SESSION, query);
    }

    private Catalog createTestingCatalog(String catalogName, CatalogName catalog) {
        CatalogName systemId = CatalogName.createSystemTablesCatalogName((CatalogName)catalog);
        Connector connector = TestAnalyzer.createTestingConnector();
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        return new Catalog(catalogName, catalog, connector, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, this.metadata, this.accessControl), systemId, (Connector)new SystemConnector((InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> this.transactionManager.getConnectorTransaction(transactionId, catalog)));
    }

    private static Connector createTestingConnector() {
        return new Connector(){
            private final ConnectorMetadata metadata = new TestingMetadata();

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return this.metadata;
            }

            public List<PropertyMetadata<?>> getAnalyzeProperties() {
                return ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"p1", (String)"test string property", (String)"", (boolean)false), (Object)PropertyMetadata.integerProperty((String)"p2", (String)"test integer property", (Integer)0, (boolean)false));
            }
        };
    }
}

