/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.expression.FieldDereference;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.ConnectorExpressionTranslator;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConnectorExpressionTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeAnalyzer TYPE_ANALYZER = new TypeAnalyzer(new SqlParser(), METADATA);
    private static final Type ROW_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5))});
    private static final LiteralEncoder LITERAL_ENCODER = new LiteralEncoder(METADATA);
    private static final Map<Symbol, Type> symbols = ImmutableMap.builder().put((Object)new Symbol("double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("row_symbol_1"), (Object)ROW_TYPE).build();
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf(symbols);
    private static final Map<String, Symbol> variableMappings = (Map)symbols.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getKey));

    @Test
    public void testTranslationToConnectorExpression() {
        this.assertTranslationToConnectorExpression((Expression)new SymbolReference("double_symbol_1"), Optional.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE)));
        this.assertTranslationToConnectorExpression((Expression)new DereferenceExpression((Expression)new SymbolReference("row_symbol_1"), new Identifier("int_symbol_1")), Optional.of(new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("row_symbol_1", ROW_TYPE), 0)));
    }

    @Test
    public void testTranslationFromConnectorExpression() {
        this.assertTranslationFromConnectorExpression((ConnectorExpression)new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), (Expression)new SymbolReference("double_symbol_1"));
        this.assertTranslationFromConnectorExpression((ConnectorExpression)new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("row_symbol_1", ROW_TYPE), 0), (Expression)new DereferenceExpression((Expression)new SymbolReference("row_symbol_1"), new Identifier("int_symbol_1")));
    }

    private void assertTranslationToConnectorExpression(Expression expression, Optional<ConnectorExpression> connectorExpression) {
        Optional translation = ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)expression, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER);
        Assert.assertTrue((translation.isPresent() == connectorExpression.isPresent() ? 1 : 0) != 0);
        if (translation.isPresent()) {
            Assert.assertEquals(translation.get(), (Object)connectorExpression.get());
        }
    }

    private void assertTranslationFromConnectorExpression(ConnectorExpression connectorExpression, Expression expected) {
        Expression translation = ConnectorExpressionTranslator.translate((ConnectorExpression)connectorExpression, variableMappings, (LiteralEncoder)LITERAL_ENCODER);
        Assert.assertEquals((Object)translation, (Object)expected);
    }
}

