/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.DesugarTryExpressionRewriter;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.type.FunctionType;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDesugarTryExpressionRewriter
extends BaseRuleTest {
    public TestDesugarTryExpressionRewriter() {
        super(new Plugin[0]);
    }

    @Test
    public void testTryExpressionDesugaringRewriter() {
        ArithmeticBinaryExpression initial = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new DecimalLiteral("1"), (Expression)new TryExpression((Expression)new DecimalLiteral("2")));
        Expression rewritten = DesugarTryExpressionRewriter.rewrite((Expression)initial, (Metadata)this.tester().getMetadata(), (TypeAnalyzer)this.tester().getTypeAnalyzer(), (Session)this.tester().getSession(), (SymbolAllocator)new SymbolAllocator());
        ArithmeticBinaryExpression expected = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new DecimalLiteral("1"), (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"$internal$try")).addArgument((Type)new FunctionType((List)ImmutableList.of(), (Type)DecimalType.createDecimalType((int)1)), (Expression)new LambdaExpression((List)ImmutableList.of(), (Expression)new DecimalLiteral("2"))).build());
        ExpressionVerifier verifier = new ExpressionVerifier(new SymbolAliases());
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)rewritten, expected)));
    }
}

