/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.scalar.JoniRegexpCasts;
import io.prestosql.operator.scalar.JsonFunctions;
import io.prestosql.operator.scalar.Re2JCastToRegexpFunction;
import io.prestosql.operator.scalar.StringFunctions;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.SqlFormatter;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.type.CodePointsType;
import io.prestosql.type.JoniRegexpType;
import io.prestosql.type.JsonPathType;
import io.prestosql.type.LikePatternType;
import io.prestosql.type.Re2JRegexp;
import io.prestosql.type.Re2JRegexpType;
import io.prestosql.type.UnknownType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.function.BiPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLiteralEncoder {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final LiteralEncoder encoder = new LiteralEncoder(this.metadata);

    @Test
    public void testEncode() {
        this.assertEncode(null, (Type)UnknownType.UNKNOWN, "null");
        this.assertEncode(null, (Type)BigintType.BIGINT, "CAST(null AS bigint)");
        this.assertEncode(123L, (Type)BigintType.BIGINT, "BIGINT '123'");
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.VARCHAR, "CAST('hello' AS varchar)");
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarbinaryType.VARBINARY, TestLiteralEncoder.literalVarbinary("hello".getBytes(StandardCharsets.UTF_8)));
        this.assertRoundTrip(JoniRegexpCasts.castVarcharToJoniRegexp((Slice)Slices.utf8Slice((String)"[a-z]")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.pattern().equals((Object)right.pattern()));
        this.assertRoundTrip(JoniRegexpCasts.castVarcharToJoniRegexp((Slice)Slices.utf8Slice((String)"[a-z]")), (Type)JoniRegexpType.JONI_REGEXP, (left, right) -> left.pattern().equals((Object)right.pattern()));
        this.assertRoundTrip(TestLiteralEncoder.castVarcharToRe2JRegexp(Slices.utf8Slice((String)"[a-z]")), this.metadata.getType(Re2JRegexpType.RE2J_REGEXP_SIGNATURE), (left, right) -> left.pattern().equals(right.pattern()));
        this.assertRoundTrip(JsonFunctions.castVarcharToJsonPath((Slice)Slices.utf8Slice((String)"$.foo")), (Type)JsonPathType.JSON_PATH, (left, right) -> left.pattern().equals(right.pattern()));
        this.assertRoundTrip(StringFunctions.castVarcharToCodePoints((Slice)Slices.utf8Slice((String)"hello")), (Type)CodePointsType.CODE_POINTS, Arrays::equals);
    }

    private void assertEncode(Object value, Type type, String expected) {
        Expression expression = this.encoder.toExpression(value, type);
        Assert.assertEquals((String)SqlFormatter.formatSql((Node)expression), (String)expected);
    }

    private <T> void assertRoundTrip(T value, Type type, BiPredicate<T, T> predicate) {
        Expression expression = this.encoder.toExpression(value, type);
        Object decodedValue = ExpressionInterpreter.expressionInterpreter((Expression)expression, (Metadata)this.metadata, (Session)SessionTestUtils.TEST_SESSION, (Map)ImmutableMap.of((Object)NodeRef.of((Node)expression), (Object)type)).evaluate();
        Assert.assertTrue((boolean)predicate.test(value, decodedValue));
    }

    private static String literalVarbinary(byte[] value) {
        return "\"@$literal$|varbinary|varbinary@$literal$<f,t>(f):t\"(\"@from_base64|varbinary|varchar@from_base64(varchar(x)):varbinary\"('" + Base64.getEncoder().encodeToString(value) + "'))";
    }

    private static Re2JRegexp castVarcharToRe2JRegexp(Slice value) {
        return Re2JCastToRegexpFunction.castToRegexp((int)Integer.MAX_VALUE, (int)5, (boolean)false, (long)Integer.MAX_VALUE, (Slice)value);
    }
}

