/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.LocalDynamicFilterConsumer;
import io.prestosql.sql.planner.LogicalPlanner;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.testing.assertions.Assert;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.testng.annotations.Test;

public class TestLocalDynamicFilterConsumer
extends BasePlanTest {
    public TestLocalDynamicFilterConsumer() {
        super((Map<String, String>)ImmutableMap.of((Object)"force_single_node_output", (Object)"false", (Object)"enable_dynamic_filtering", (Object)"true", (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.NONE.name(), (Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.BROADCAST.name()));
    }

    @Test
    public void testSimple() throws ExecutionException, InterruptedException {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Multimap)ImmutableMultimap.of((Object)new DynamicFilterId("123"), (Object)new Symbol("a")), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getNodeLocalDynamicFilterForSymbols();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new Symbol("a"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L)));
    }

    @Test
    public void testMultipleProbeSymbols() throws ExecutionException, InterruptedException {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Multimap)ImmutableMultimap.of((Object)new DynamicFilterId("123"), (Object)new Symbol("a1"), (Object)new DynamicFilterId("123"), (Object)new Symbol("a2")), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getNodeLocalDynamicFilterForSymbols();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new Symbol("a1"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L), (Object)new Symbol("a2"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L)));
    }

    @Test
    public void testMultiplePartitions() throws ExecutionException, InterruptedException {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Multimap)ImmutableMultimap.of((Object)new DynamicFilterId("123"), (Object)new Symbol("a")), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getNodeLocalDynamicFilterForSymbols();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L))));
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new Symbol("a"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L))));
    }

    @Test
    public void testNone() throws ExecutionException, InterruptedException {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Multimap)ImmutableMultimap.of((Object)new DynamicFilterId("123"), (Object)new Symbol("a")), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getNodeLocalDynamicFilterForSymbols();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.none());
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new Symbol("a"), (Object)Domain.none((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMultipleColumns() throws ExecutionException, InterruptedException {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Multimap)ImmutableMultimap.of((Object)new DynamicFilterId("123"), (Object)new Symbol("a"), (Object)new DynamicFilterId("456"), (Object)new Symbol("b")), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER, (Object)new DynamicFilterId("456"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getNodeLocalDynamicFilterForSymbols();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new Symbol("a"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new Symbol("b"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L)));
    }

    @Test
    public void testMultiplePartitionsAndColumns() throws ExecutionException, InterruptedException {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Multimap)ImmutableMultimap.of((Object)new DynamicFilterId("123"), (Object)new Symbol("a"), (Object)new DynamicFilterId("456"), (Object)new Symbol("b")), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER, (Object)new DynamicFilterId("456"), (Object)BigintType.BIGINT), 2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getNodeLocalDynamicFilterForSymbols();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L))));
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)200L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new Symbol("a"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L)), (Object)new Symbol("b"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)100L, (Object)200L))));
    }

    @Test
    public void testCreateSingleColumn() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("SELECT count() FROM lineitem, orders WHERE lineitem.orderkey = orders.orderkey AND orders.custkey < 10", LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false);
        JoinNode joinNode = (JoinNode)this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findOnlyElement();
        LocalDynamicFilterConsumer filter = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.copyOf(subplan.getFragment().getSymbols().values()), (int)1);
        DynamicFilterId filterId = (DynamicFilterId)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
        Symbol probeSymbol = ((JoinNode.EquiJoinClause)Iterables.getOnlyElement((Iterable)joinNode.getCriteria())).getLeft();
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L))));
        Assert.assertEquals((Map)((Map)filter.getNodeLocalDynamicFilterForSymbols().get()), (Map)ImmutableMap.of((Object)probeSymbol, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)));
    }

    @Test
    public void testCreateDistributedJoin() throws Exception {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", "PARTITIONED").build();
        SubPlan subplan = this.subplan("SELECT count() FROM nation, region WHERE nation.regionkey = region.regionkey AND region.comment = 'abc'", LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
        JoinNode joinNode = (JoinNode)this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findOnlyElement();
        LocalDynamicFilterConsumer filter = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.copyOf(subplan.getFragment().getSymbols().values()), (int)1);
        DynamicFilterId filterId = (DynamicFilterId)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
        org.testng.Assert.assertFalse((boolean)joinNode.getDynamicFilters().isEmpty());
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L))));
        Assert.assertEquals((Map)((Map)filter.getNodeLocalDynamicFilterForSymbols().get()), (Map)ImmutableMap.of());
        Assert.assertEquals((Map)((Map)filter.getDynamicFilterDomains().get()), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L)));
    }

    @Test
    public void testCreateMultipleCriteria() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("SELECT count() FROM lineitem, partsupp WHERE lineitem.partkey = partsupp.partkey AND lineitem.suppkey = partsupp.suppkey AND partsupp.availqty < 10", LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false);
        JoinNode joinNode = (JoinNode)this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findOnlyElement();
        LocalDynamicFilterConsumer filter = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.copyOf(subplan.getFragment().getSymbols().values()), (int)1);
        List filterIds = (List)filter.getBuildChannels().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((DynamicFilterId)filterIds.get(0)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)4L), (Object)((DynamicFilterId)filterIds.get(1)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))));
        Assert.assertEquals((Map)((Map)filter.getNodeLocalDynamicFilterForSymbols().get()), (Map)ImmutableMap.of((Object)new Symbol("partkey"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)4L), (Object)new Symbol("suppkey"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L)));
    }

    @Test
    public void testCreateMultipleJoins() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("SELECT count() FROM lineitem, orders, part WHERE lineitem.orderkey = orders.orderkey AND lineitem.partkey = part.partkey AND orders.custkey < 10 AND part.name = 'abc'", LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false);
        List joinNodes = this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findAll();
        Assert.assertEquals((int)joinNodes.size(), (int)2);
        for (JoinNode joinNode : joinNodes) {
            LocalDynamicFilterConsumer filter = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.copyOf(subplan.getFragment().getSymbols().values()), (int)1);
            DynamicFilterId filterId = (DynamicFilterId)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
            Symbol probeSymbol = ((JoinNode.EquiJoinClause)Iterables.getOnlyElement((Iterable)joinNode.getCriteria())).getLeft();
            filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L))));
            Assert.assertEquals((Map)((Map)filter.getNodeLocalDynamicFilterForSymbols().get()), (Map)ImmutableMap.of((Object)probeSymbol, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L)));
        }
    }

    @Test
    public void testCreateProbeSideUnion() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("WITH union_table(key) AS ((SELECT partkey FROM part) UNION (SELECT suppkey FROM supplier)) SELECT count() FROM union_table, nation WHERE union_table.key = nation.nationkey AND nation.comment = 'abc'", LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, true);
        JoinNode joinNode = (JoinNode)this.searchJoins(subplan.getFragment()).findOnlyElement();
        LocalDynamicFilterConsumer filter = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.copyOf(subplan.getFragment().getSymbols().values()), (int)1);
        DynamicFilterId filterId = (DynamicFilterId)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)7L))));
        Assert.assertEquals((Map)((Map)filter.getNodeLocalDynamicFilterForSymbols().get()), (Map)ImmutableMap.of((Object)new Symbol("partkey"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)7L), (Object)new Symbol("suppkey"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)7L)));
    }

    private PlanNodeSearcher searchJoins(PlanFragment fragment) {
        return PlanNodeSearcher.searchFrom((PlanNode)fragment.getRoot()).where(node -> node instanceof JoinNode);
    }
}

