/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.LocalDynamicFiltersCollector;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.testing.assertions.Assert;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

public class TestLocalDynamicFiltersCollector {
    @Test
    public void testCollector() {
        Symbol symbol = new Symbol("symbol");
        ImmutableSet probeSymbols = ImmutableSet.of((Object)symbol);
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector();
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols), (Object)TupleDomain.all());
        collector.addDynamicFilter((Map)ImmutableMap.of());
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols), (Object)TupleDomain.all());
        collector.addDynamicFilter(this.toDomainMap(symbol, 1L, 2L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols), this.tupleDomain(symbol, 1L, 2L));
        collector.addDynamicFilter(this.toDomainMap(symbol, 2L, 3L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols), this.tupleDomain(symbol, 2L));
        collector.addDynamicFilter(this.toDomainMap(symbol, 0L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols), (Object)TupleDomain.none());
    }

    @Test
    public void testCollectorMultipleScans() {
        Symbol symbol1 = new Symbol("symbol1");
        Symbol symbol2 = new Symbol("symbol2");
        ImmutableSet probeSymbols1 = ImmutableSet.of((Object)symbol1);
        ImmutableSet probeSymbols2 = ImmutableSet.of((Object)symbol2);
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector();
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols1), (Object)TupleDomain.all());
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols2), (Object)TupleDomain.all());
        collector.addDynamicFilter(this.toDomainMap(symbol1, 1L, 2L));
        collector.addDynamicFilter(this.toDomainMap(symbol2, 2L, 3L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols1), this.tupleDomain(symbol1, 1L, 2L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols2), this.tupleDomain(symbol2, 2L, 3L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)ImmutableSet.of((Object)symbol1, (Object)symbol2)), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol1, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L)), (Object)symbol2, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)2L, (Object)3L)))));
        collector.addDynamicFilter(this.toDomainMap(symbol1, 0L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols1), (Object)TupleDomain.none());
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols2), this.tupleDomain(symbol2, 2L, 3L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)ImmutableSet.of((Object)symbol1, (Object)symbol2)), (Object)TupleDomain.none());
    }

    @Test
    public void testCollectorMultipleScansNone() {
        Symbol symbol1 = new Symbol("symbol1");
        Symbol symbol2 = new Symbol("symbol2");
        ImmutableSet probeSymbols1 = ImmutableSet.of((Object)symbol1);
        ImmutableSet probeSymbols2 = ImmutableSet.of((Object)symbol2);
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector();
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols1), (Object)TupleDomain.all());
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols2), (Object)TupleDomain.all());
        collector.addDynamicFilter(this.toDomainMap(symbol1, 1L, 2L));
        collector.addDynamicFilter(this.toDomainMap(symbol2, 2L, 3L));
        collector.addDynamicFilter((Map)ImmutableMap.of((Object)symbol1, (Object)Domain.none((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols1), (Object)TupleDomain.none());
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols2), this.tupleDomain(symbol2, 2L, 3L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)ImmutableSet.of((Object)symbol1, (Object)symbol2)), (Object)TupleDomain.none());
        collector.addDynamicFilter(this.toDomainMap(symbol1, 1L, 2L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols1), (Object)TupleDomain.none());
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)probeSymbols2), this.tupleDomain(symbol2, 2L, 3L));
        Assert.assertEquals((Object)collector.getDynamicFilter((Set)ImmutableSet.of((Object)symbol1, (Object)symbol2)), (Object)TupleDomain.none());
    }

    private TupleDomain<Symbol> tupleDomain(Symbol symbol, Long ... values) {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.copyOf((Object[])values))));
    }

    private Map<Symbol, Domain> toDomainMap(Symbol symbol, Long ... values) {
        return ImmutableMap.of((Object)symbol, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.copyOf((Object[])values)));
    }
}

