/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Joiner;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import java.io.Closeable;
import java.util.Collections;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLocalExecutionPlanner {
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.runner});
        this.runner = null;
    }

    @Test
    public void testProjectionCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.runner.execute("SELECT " + outer)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR).hasMessageStartingWith("Query exceeded maximum columns");
    }

    @Test
    public void testFilterCompilerFailure() {
        String filterQueryInner = "FROM (SELECT rand() as c1, rand() as c2, rand() as c3)";
        String filterQueryWhere = "WHERE c1 = rand() OR " + Joiner.on((String)" AND ").join(Collections.nCopies(250, "c1 = rand()")) + " OR " + Joiner.on((String)" AND ").join(Collections.nCopies(200, " c2 = rand()")) + " OR " + Joiner.on((String)" AND ").join(Collections.nCopies(200, " c3 = rand()"));
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.runner.execute("SELECT * " + filterQueryInner + filterQueryWhere)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR).hasMessageStartingWith("Query exceeded maximum filters");
    }
}

