/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import org.testng.annotations.Test;

public class TestOrderBy
extends BasePlanTest {
    @Test
    public void testRedundantOrderByInSubquery() {
        this.assertPlan("SELECT * FROM (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x)", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testRequiredOrderByInSubquery() {
        this.assertPlan("SELECT * FROM (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x LIMIT 1)", PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testRedundantOrderByInScalarSubquery() {
        this.assertPlan("SELECT (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x) FROM (VALUES 10)", PlanMatchPattern.output(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testRequiredOrderByInScalarSubquery() {
        this.assertPlan("SELECT (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x LIMIT 1) FROM (VALUES 10)", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testRequiredOrderByInUnion() {
        this.assertPlan("VALUES 1 UNION ALL VALUES 2 ORDER BY 1 ", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testRedundantOrderByInUnion() {
        this.assertPlan("SELECT * FROM (   VALUES 1    UNION ALL    VALUES 2    ORDER BY 1 )", PlanMatchPattern.output(PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }
}

