/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.ConnectorExpressionTranslator;
import io.prestosql.sql.planner.PartialTranslator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TransactionId;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartialTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setTransactionId(TransactionId.create()).build();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeAnalyzer TYPE_ANALYZER = new TypeAnalyzer(new SqlParser(), METADATA);
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("double_symbol_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bigint_symbol_1"), (Object)BigintType.BIGINT).put((Object)new Symbol("row_symbol_1"), (Object)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5))})).build());

    @Test
    public void testPartialTranslator() {
        SymbolReference rowSymbolReference = new SymbolReference("row_symbol_1");
        DereferenceExpression dereferenceExpression1 = new DereferenceExpression((Expression)rowSymbolReference, new Identifier("int_symbol_1"));
        DereferenceExpression dereferenceExpression2 = new DereferenceExpression((Expression)rowSymbolReference, new Identifier("varchar_symbol_1"));
        StringLiteral stringLiteral = new StringLiteral("abcd");
        SymbolReference symbolReference1 = new SymbolReference("double_symbol_1");
        this.assertFullTranslation((Expression)symbolReference1);
        this.assertFullTranslation((Expression)dereferenceExpression1);
        this.assertFullTranslation((Expression)stringLiteral);
        ArithmeticBinaryExpression binaryExpression = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)symbolReference1, (Expression)dereferenceExpression1);
        this.assertPartialTranslation((Expression)binaryExpression, (List<Expression>)ImmutableList.of((Object)symbolReference1, (Object)dereferenceExpression1));
        ImmutableList functionArguments = ImmutableList.of((Object)stringLiteral, (Object)dereferenceExpression2);
        FunctionCall functionCallExpression = new FunctionCall(QualifiedName.of((String)"concat"), (List)functionArguments);
        this.assertPartialTranslation((Expression)functionCallExpression, (List<Expression>)functionArguments);
    }

    private void assertPartialTranslation(Expression expression, List<Expression> subexpressions) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER);
        Assert.assertEquals((int)subexpressions.size(), (int)translation.size());
        for (Expression subexpression : subexpressions) {
            Assert.assertEquals(translation.get(NodeRef.of((Node)subexpression)), ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)subexpression, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER).get());
        }
    }

    private void assertFullTranslation(Expression expression) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER);
        Assert.assertEquals((Object)Iterables.getOnlyElement(translation.keySet()), (Object)NodeRef.of((Node)expression));
        Assert.assertEquals((Object)Iterables.getOnlyElement(translation.values()), ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)expression, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER).get());
    }
}

