/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestUnwrapCastInComparison
extends BasePlanTest {
    @Test
    public void testEquals() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a = DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a = DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '32766.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '-32767.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = DOUBLE '-32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a = DOUBLE '-18446744073709551616'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testNotEquals() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a <> DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a <> DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '32766.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a <> DOUBLE '18446744073709551616'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '-32767.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> DOUBLE '-32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testLessThan() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a < DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a < DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '2'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '32766.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '-32767.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < DOUBLE '-32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a < DOUBLE '-18446744073709551616'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a <= DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a <= DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '2'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '32766.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A < SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a <= DOUBLE '18446744073709551616'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <= SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '-32767.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= DOUBLE '-32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testGreaterThan() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a > DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= SMALLINT '2'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a > DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= BIGINT '2'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '32766.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a > DOUBLE '18446744073709551616'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '-32767.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A <> SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > DOUBLE '-32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a >= DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a >= DOUBLE '1.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '1.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= SMALLINT '2'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '32766.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A >= SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '-32767.9'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A > SMALLINT '-32768' ", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= DOUBLE '-32768.1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a >= DOUBLE '-18446744073709551616'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testDistinctFrom() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS DISTINCT FROM SMALLINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS DISTINCT FROM BIGINT '1'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '1.1'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '1.9'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '1.9'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '32766'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS DISTINCT FROM SMALLINT '32766'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '32766.9'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS DISTINCT FROM SMALLINT '32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '32768.1'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a IS DISTINCT FROM DOUBLE '18446744073709551616'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '-32767'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS DISTINCT FROM SMALLINT '-32767'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '-32767.9'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '-32768'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A IS DISTINCT FROM SMALLINT '-32768'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM DOUBLE '-32768.1'", PlanMatchPattern.output(PlanMatchPattern.values("A")));
    }

    @Test
    public void testNull() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a = CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a > CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a >= CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <= CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("CAST(NULL AS BOOLEAN)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("NOT (CAST(A AS DOUBLE) IS NULL)", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a IS DISTINCT FROM CAST(NULL AS DOUBLE)", PlanMatchPattern.output(PlanMatchPattern.filter("NOT (CAST(A AS DOUBLE) IS NULL)", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testNaN() {
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = nan()", PlanMatchPattern.output(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a = nan()", PlanMatchPattern.output(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a < nan()", PlanMatchPattern.output(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a <> nan()", PlanMatchPattern.output(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a IS DISTINCT FROM nan()", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '0') t(a) WHERE a IS DISTINCT FROM nan()", PlanMatchPattern.output(PlanMatchPattern.values("A")));
        this.assertPlan("SELECT * FROM (VALUES REAL '0.0') t(a) WHERE a = nan()", PlanMatchPattern.output(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES REAL '0.0') t(a) WHERE a < nan()", PlanMatchPattern.output(PlanMatchPattern.filter("A IS NULL AND NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES REAL '0.0') t(a) WHERE a <> nan()", PlanMatchPattern.output(PlanMatchPattern.filter("NOT (A IS NULL) OR NULL", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES REAL '0.0') t(a) WHERE a IS DISTINCT FROM nan()", PlanMatchPattern.output(PlanMatchPattern.filter("A IS DISTINCT FROM CAST(nan() AS REAL)", PlanMatchPattern.values("A"))));
    }

    @Test
    public void smokeTests() {
        for (String type : Arrays.asList("SMALLINT", "INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.assertPlan(String.format("SELECT * FROM (VALUES TINYINT '1') t(a) WHERE a = %s '1'", type), PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = TINYINT '1'", PlanMatchPattern.values("A"))));
        }
        for (String type : Arrays.asList("INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.assertPlan(String.format("SELECT * FROM (VALUES SMALLINT '0') t(a) WHERE a = %s '1'", type), PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = SMALLINT '1'", PlanMatchPattern.values("A"))));
        }
        for (String type : Arrays.asList("BIGINT", "DOUBLE")) {
            this.assertPlan(String.format("SELECT * FROM (VALUES INTEGER '1') t(a) WHERE a = %s '1'", type), PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = 1", PlanMatchPattern.values("A"))));
        }
        this.assertPlan("SELECT * FROM (VALUES REAL '1') t(a) WHERE a = DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = REAL '1.0'", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testTermOrder() {
        this.assertPlan("SELECT * FROM (VALUES REAL '1') t(a) WHERE DOUBLE '1' = a", PlanMatchPattern.anyTree(PlanMatchPattern.filter("A = REAL '1.0'", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testNoEffect() {
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = DOUBLE '9007199254740992'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS DOUBLE) = 9.007199254740992E15", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = DOUBLE '9223372036854775807'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS DOUBLE) = 9.223372036854776E18", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = DOUBLE '-9007199254740992'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS DOUBLE) = -9.007199254740992E15", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = DOUBLE '-9223372036854775807'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS DOUBLE) = -9.223372036854776E18", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = REAL '8388608'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '8388608.0'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = REAL '9223372036854775807'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '9.223372E18'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = REAL '-8388608'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '-8388608.0'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES BIGINT '1') t(a) WHERE a = REAL '-9223372036854775807'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '-9.223372E18'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES INTEGER '1') t(a) WHERE a = REAL '8388608'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '8388608.0'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES INTEGER '1') t(a) WHERE a = REAL '2147483647'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '2.14748365E9'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES INTEGER '1') t(a) WHERE a = REAL '-8388608'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '-8388608.0'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES INTEGER '1') t(a) WHERE a = REAL '-2147483647'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '-2.14748365E9'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES CAST('1' AS DECIMAL(16))) t(a) WHERE a = DOUBLE '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS DOUBLE) = 1E0", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES CAST('1' AS DECIMAL(8))) t(a) WHERE a = REAL '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS REAL) = REAL '1.0'", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES VARCHAR '1') t(a) WHERE CAST(a AS INTEGER) = INTEGER '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS INTEGER) = 1", PlanMatchPattern.values("A"))));
        this.assertPlan("SELECT * FROM (VALUES DOUBLE '1') t(a) WHERE CAST(a AS INTEGER) = INTEGER '1'", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(A AS INTEGER) = 1", PlanMatchPattern.values("A"))));
    }
}

