/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.ExpressionTestUtils;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregationFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;

    public AggregationFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "functionCall is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> result = Optional.empty();
        if (!(node instanceof AggregationNode)) {
            return result;
        }
        AggregationNode aggregationNode = (AggregationNode)node;
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        for (Map.Entry assignment : aggregationNode.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)assignment.getValue();
            if (!AggregationFunctionMatcher.aggregationMatches(aggregation, expectedCall)) continue;
            Preconditions.checkState((boolean)result.isEmpty(), (String)"Ambiguous function calls in %s", (Object)aggregationNode);
            result = Optional.of((Symbol)assignment.getKey());
        }
        return result;
    }

    private static boolean aggregationMatches(AggregationNode.Aggregation aggregation, FunctionCall expectedCall) {
        if (expectedCall.getWindow().isPresent()) {
            return false;
        }
        Preconditions.checkArgument((boolean)aggregation.getFilter().isEmpty(), (Object)"Cannot match filters");
        return Objects.equals(ExpressionTestUtils.getFunctionName(expectedCall), QualifiedName.of((String)aggregation.getResolvedFunction().getSignature().getName())) && aggregation.getFilter().isEmpty() && Objects.equals(expectedCall.getOrderBy().map(OrderingScheme::fromOrderBy), aggregation.getOrderingScheme()) && Objects.equals(expectedCall.isDistinct(), aggregation.isDistinct()) && Objects.equals(expectedCall.getArguments(), aggregation.getArguments());
    }

    public String toString() {
        return this.callMaker.toString();
    }
}

