/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class AggregationMatcher
implements Matcher {
    private final PlanMatchPattern.GroupingSetDescriptor groupingSets;
    private final Map<Symbol, Symbol> masks;
    private final List<String> preGroupedSymbols;
    private final Optional<Symbol> groupId;
    private final AggregationNode.Step step;

    public AggregationMatcher(PlanMatchPattern.GroupingSetDescriptor groupingSets, List<String> preGroupedSymbols, Map<Symbol, Symbol> masks, Optional<Symbol> groupId, AggregationNode.Step step) {
        this.groupingSets = groupingSets;
        this.masks = masks;
        this.preGroupedSymbols = preGroupedSymbols;
        this.groupId = groupId;
        this.step = step;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof AggregationNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        AggregationNode aggregationNode = (AggregationNode)node;
        if (this.groupId.isPresent() != aggregationNode.getGroupIdSymbol().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.groupingSets.getGroupingKeys(), aggregationNode.getGroupingKeys(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        if (this.groupingSets.getGroupingSetCount() != aggregationNode.getGroupingSetCount()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.groupingSets.getGlobalGroupingSets().equals(aggregationNode.getGlobalGroupingSets())) {
            return MatchResult.NO_MATCH;
        }
        List aggregationsWithMask = aggregationNode.getAggregations().entrySet().stream().filter(entry -> ((AggregationNode.Aggregation)entry.getValue()).isDistinct()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (aggregationsWithMask.size() != this.masks.keySet().size()) {
            return MatchResult.NO_MATCH;
        }
        for (Symbol symbol : aggregationsWithMask) {
            if (this.masks.keySet().contains(symbol)) continue;
            return MatchResult.NO_MATCH;
        }
        if (this.step != aggregationNode.getStep()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.preGroupedSymbols, aggregationNode.getPreGroupedSymbols(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        if (!this.preGroupedSymbols.isEmpty() && !aggregationNode.isStreamable()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    static boolean matches(Collection<String> expectedAliases, Collection<Symbol> actualSymbols, SymbolAliases symbolAliases) {
        if (expectedAliases.size() != actualSymbols.size()) {
            return false;
        }
        List expectedSymbols = (List)expectedAliases.stream().map(alias -> new Symbol(symbolAliases.get((String)alias).getName())).collect(ImmutableList.toImmutableList());
        for (Symbol symbol : expectedSymbols) {
            if (actualSymbols.contains(symbol)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupingSets", (Object)this.groupingSets).add("preGroupedSymbols", this.preGroupedSymbols).add("masks", this.masks).add("groudId", this.groupId).add("step", (Object)this.step).toString();
    }
}

