/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ColumnHandleMatcher
implements RvalueMatcher {
    private final Predicate<ColumnHandle> matcher;

    public ColumnHandleMatcher(Predicate<ColumnHandle> handleMatcher) {
        this.matcher = Objects.requireNonNull(handleMatcher, "handleMatcher is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof TableScanNode)) {
            return Optional.empty();
        }
        Map assignments = ((TableScanNode)node).getAssignments();
        for (Map.Entry entry : assignments.entrySet()) {
            if (!this.matcher.test((ColumnHandle)entry.getValue())) continue;
            return Optional.of((Symbol)entry.getKey());
        }
        return Optional.empty();
    }
}

