/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAlias;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DynamicFilterMatcher
implements Matcher {
    private final Metadata metadata;
    private final Map<SymbolAlias, SymbolAlias> expectedDynamicFilters;
    private final Map<String, String> joinExpectedMappings;
    private final Map<String, String> filterExpectedMappings;
    private final Optional<Expression> expectedStaticFilter;
    private JoinNode joinNode;
    private SymbolAliases symbolAliases;
    private FilterNode filterNode;

    public DynamicFilterMatcher(Metadata metadata, Map<SymbolAlias, SymbolAlias> expectedDynamicFilters, Optional<Expression> expectedStaticFilter) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.expectedDynamicFilters = Objects.requireNonNull(expectedDynamicFilters, "expectedDynamicFilters is null");
        this.joinExpectedMappings = (Map)expectedDynamicFilters.values().stream().collect(ImmutableMap.toImmutableMap(rightSymbol -> rightSymbol.toString() + "_alias", SymbolAlias::toString));
        this.filterExpectedMappings = (Map)expectedDynamicFilters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toString(), entry -> ((SymbolAlias)entry.getValue()).toString() + "_alias"));
        this.expectedStaticFilter = Objects.requireNonNull(expectedStaticFilter, "expectedStaticFilter is null");
    }

    public MatchResult match(Metadata metadata, JoinNode joinNode, SymbolAliases symbolAliases) {
        Preconditions.checkState((this.joinNode == null ? 1 : 0) != 0, (Object)"joinNode must be null at this point");
        this.joinNode = joinNode;
        this.symbolAliases = symbolAliases;
        return new MatchResult(this.match(metadata));
    }

    public MatchResult match(Metadata metadata, FilterNode filterNode, SymbolAliases symbolAliases) {
        Preconditions.checkState((this.filterNode == null ? 1 : 0) != 0, (Object)"filterNode must be null at this point");
        this.filterNode = filterNode;
        this.symbolAliases = symbolAliases;
        boolean staticFilterMatches = this.expectedStaticFilter.map(filter -> {
            ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
            Expression staticFilter = ExpressionUtils.combineConjuncts((Metadata)metadata, (Collection)DynamicFilters.extractDynamicFilters((Expression)filterNode.getPredicate()).getStaticConjuncts());
            return (Boolean)verifier.process((Node)staticFilter, filter);
        }).orElse(true);
        return new MatchResult(this.match(metadata) && staticFilterMatches);
    }

    private boolean match(Metadata metadata) {
        Preconditions.checkState((this.symbolAliases != null ? 1 : 0) != 0, (Object)"symbolAliases is null");
        if (this.filterNode == null || this.joinNode == null) {
            return true;
        }
        Map idToProbeSymbolMap = (Map)DynamicFilters.extractDynamicFilters((Expression)this.filterNode.getPredicate()).getDynamicConjuncts().stream().collect(ImmutableMap.toImmutableMap(DynamicFilters.Descriptor::getId, filter -> Symbol.from((Expression)filter.getInput())));
        Map idToBuildSymbolMap = this.joinNode.getDynamicFilters();
        if (idToProbeSymbolMap == null) {
            return false;
        }
        if (idToProbeSymbolMap.size() != this.expectedDynamicFilters.size()) {
            return false;
        }
        HashMap<Symbol, Symbol> actual = new HashMap<Symbol, Symbol>();
        for (Map.Entry idToProbeSymbol : idToProbeSymbolMap.entrySet()) {
            DynamicFilterId id = (DynamicFilterId)idToProbeSymbol.getKey();
            Symbol probe = (Symbol)idToProbeSymbol.getValue();
            Symbol build = (Symbol)idToBuildSymbolMap.get(id);
            if (build == null) {
                return false;
            }
            actual.put(probe, build);
        }
        Map expected = (Map)this.expectedDynamicFilters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toSymbol(this.symbolAliases), entry -> ((SymbolAlias)entry.getValue()).toSymbol(this.symbolAliases)));
        return expected.equals(actual);
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof FilterNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof FilterNode)) {
            return new MatchResult(false);
        }
        return this.match(metadata, (FilterNode)node, symbolAliases);
    }

    public Map<String, String> getJoinExpectedMappings() {
        return this.joinExpectedMappings;
    }

    public String toString() {
        String predicate = Joiner.on((String)" AND ").join((Iterable)this.filterExpectedMappings.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(ImmutableList.toImmutableList()));
        return MoreObjects.toStringHelper((Object)this).add("dynamicPredicate", (Object)predicate).add("staticPredicate", this.expectedStaticFilter).toString();
    }
}

