/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanTestSymbol;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MarkDistinctMatcher
implements Matcher {
    private final PlanTestSymbol markerSymbol;
    private final List<PlanTestSymbol> distinctSymbols;
    private final Optional<PlanTestSymbol> hashSymbol;

    public MarkDistinctMatcher(PlanTestSymbol markerSymbol, List<PlanTestSymbol> distinctSymbols, Optional<PlanTestSymbol> hashSymbol) {
        this.markerSymbol = Objects.requireNonNull(markerSymbol, "markerSymbol is null");
        this.distinctSymbols = ImmutableList.copyOf(distinctSymbols);
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof MarkDistinctNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        MarkDistinctNode markDistinctNode = (MarkDistinctNode)node;
        if (!markDistinctNode.getHashSymbol().equals(this.hashSymbol.map(alias -> alias.toSymbol(symbolAliases)))) {
            return MatchResult.NO_MATCH;
        }
        if (!ImmutableSet.copyOf((Collection)markDistinctNode.getDistinctSymbols()).equals(this.distinctSymbols.stream().map(alias -> alias.toSymbol(symbolAliases)).collect(ImmutableSet.toImmutableSet()))) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(this.markerSymbol.toString(), markDistinctNode.getMarkerSymbol().toSymbolReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("markerSymbol", (Object)this.markerSymbol).add("distinctSymbols", this.distinctSymbols).add("hashSymbol", this.hashSymbol).toString();
    }
}

