/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.AggregationFunctionMatcher;
import io.prestosql.sql.planner.assertions.AggregationMatcher;
import io.prestosql.sql.planner.assertions.AggregationStepMatcher;
import io.prestosql.sql.planner.assertions.AliasMatcher;
import io.prestosql.sql.planner.assertions.AliasPresent;
import io.prestosql.sql.planner.assertions.AnySymbol;
import io.prestosql.sql.planner.assertions.AssignUniqueIdMatcher;
import io.prestosql.sql.planner.assertions.ColumnHandleMatcher;
import io.prestosql.sql.planner.assertions.ColumnReference;
import io.prestosql.sql.planner.assertions.ConnectorAwareTableScanMatcher;
import io.prestosql.sql.planner.assertions.CorrelationMatcher;
import io.prestosql.sql.planner.assertions.DistinctLimitMatcher;
import io.prestosql.sql.planner.assertions.DynamicFilterMatcher;
import io.prestosql.sql.planner.assertions.EquiJoinClauseProvider;
import io.prestosql.sql.planner.assertions.ExchangeMatcher;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.FilterMatcher;
import io.prestosql.sql.planner.assertions.FunctionCallProvider;
import io.prestosql.sql.planner.assertions.GroupIdMatcher;
import io.prestosql.sql.planner.assertions.IdentityProjectionMatcher;
import io.prestosql.sql.planner.assertions.IndexJoinEquiClauseProvider;
import io.prestosql.sql.planner.assertions.IndexJoinMatcher;
import io.prestosql.sql.planner.assertions.IndexSourceMatcher;
import io.prestosql.sql.planner.assertions.JoinMatcher;
import io.prestosql.sql.planner.assertions.LimitMatcher;
import io.prestosql.sql.planner.assertions.MarkDistinctMatcher;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.NotPlanNodeMatcher;
import io.prestosql.sql.planner.assertions.OffsetMatcher;
import io.prestosql.sql.planner.assertions.OrdinalitySymbolMatcher;
import io.prestosql.sql.planner.assertions.OutputMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchingState;
import io.prestosql.sql.planner.assertions.PlanNodeMatcher;
import io.prestosql.sql.planner.assertions.PlanTestSymbol;
import io.prestosql.sql.planner.assertions.PredicateMatcher;
import io.prestosql.sql.planner.assertions.RowNumberMatcher;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.SemiJoinMatcher;
import io.prestosql.sql.planner.assertions.SortMatcher;
import io.prestosql.sql.planner.assertions.SpatialJoinMatcher;
import io.prestosql.sql.planner.assertions.SpecificationProvider;
import io.prestosql.sql.planner.assertions.StatsOutputRowCountMatcher;
import io.prestosql.sql.planner.assertions.StrictAssignedSymbolsMatcher;
import io.prestosql.sql.planner.assertions.StrictSymbolsMatcher;
import io.prestosql.sql.planner.assertions.SymbolAlias;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.SymbolCardinalityMatcher;
import io.prestosql.sql.planner.assertions.TableScanMatcher;
import io.prestosql.sql.planner.assertions.TableWriterMatcher;
import io.prestosql.sql.planner.assertions.TopNMatcher;
import io.prestosql.sql.planner.assertions.TopNRowNumberMatcher;
import io.prestosql.sql.planner.assertions.UnnestMatcher;
import io.prestosql.sql.planner.assertions.UnnestedSymbolMatcher;
import io.prestosql.sql.planner.assertions.ValuesMatcher;
import io.prestosql.sql.planner.assertions.WindowFrameProvider;
import io.prestosql.sql.planner.assertions.WindowMatcher;
import io.prestosql.sql.planner.iterative.GroupReference;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.GroupIdNode;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.WindowFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public final class PlanMatchPattern {
    private final List<Matcher> matchers = new ArrayList<Matcher>();
    private final List<PlanMatchPattern> sourcePatterns;
    private boolean anyTree;

    public static PlanMatchPattern node(Class<? extends PlanNode> nodeClass, PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).with(new PlanNodeMatcher(nodeClass));
    }

    public static PlanMatchPattern any(PlanMatchPattern ... sources) {
        return new PlanMatchPattern((List<PlanMatchPattern>)ImmutableList.copyOf((Object[])sources));
    }

    public static PlanMatchPattern anyTree(PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).matchToAnyNodeTree();
    }

    public static PlanMatchPattern anyNot(Class<? extends PlanNode> excludeNodeClass, PlanMatchPattern ... sources) {
        return PlanMatchPattern.any(sources).with(new NotPlanNodeMatcher(excludeNodeClass));
    }

    public static PlanMatchPattern tableScan(String expectedTableName) {
        return TableScanMatcher.create(expectedTableName);
    }

    public static PlanMatchPattern tableScan(String expectedTableName, Map<String, String> columnReferences) {
        PlanMatchPattern result = PlanMatchPattern.tableScan(expectedTableName);
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern tableScan(Predicate<ConnectorTableHandle> expectedTable, TupleDomain<Predicate<ColumnHandle>> enforcedConstraints, Map<String, Predicate<ColumnHandle>> expectedColumns) {
        PlanMatchPattern pattern = ConnectorAwareTableScanMatcher.create(expectedTable, enforcedConstraints);
        expectedColumns.entrySet().forEach(column -> pattern.withAlias((String)column.getKey(), (RvalueMatcher)new ColumnHandleMatcher((Predicate)column.getValue())));
        return pattern;
    }

    public static PlanMatchPattern strictTableScan(String expectedTableName, Map<String, String> columnReferences) {
        return PlanMatchPattern.tableScan(expectedTableName, columnReferences).withExactAssignedOutputs((Collection)columnReferences.values().stream().map(columnName -> PlanMatchPattern.columnReference(expectedTableName, columnName)).collect(ImmutableList.toImmutableList()));
    }

    public static PlanMatchPattern constrainedTableScan(String expectedTableName, Map<String, Domain> constraint) {
        return TableScanMatcher.builder(expectedTableName).expectedConstraint(constraint).build();
    }

    public static PlanMatchPattern constrainedTableScan(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        PlanMatchPattern result = PlanMatchPattern.constrainedTableScan(expectedTableName, constraint);
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern constrainedTableScanWithTableLayout(String expectedTableName, Map<String, Domain> constraint, Map<String, String> columnReferences) {
        PlanMatchPattern result = TableScanMatcher.builder(expectedTableName).expectedConstraint(constraint).hasTableLayout().build();
        return result.addColumnReferences(expectedTableName, columnReferences);
    }

    public static PlanMatchPattern indexJoin(IndexJoinNode.Type type, List<ExpectedValueProvider<IndexJoinNode.EquiJoinClause>> criteria, Optional<String> probeHashSymbol, Optional<String> indexHashSymbol, PlanMatchPattern probeSource, PlanMatchPattern indexSource) {
        return PlanMatchPattern.node(IndexJoinNode.class, probeSource, indexSource).with(new IndexJoinMatcher(type, criteria, probeHashSymbol.map(SymbolAlias::new), indexHashSymbol.map(SymbolAlias::new)));
    }

    public static ExpectedValueProvider<IndexJoinNode.EquiJoinClause> indexJoinEquiClause(String probe, String index) {
        return new IndexJoinEquiClauseProvider(new SymbolAlias(probe), new SymbolAlias(index));
    }

    public static PlanMatchPattern constrainedIndexSource(String expectedTableName, Map<String, String> columnReferences) {
        return PlanMatchPattern.node(IndexSourceNode.class, new PlanMatchPattern[0]).with(new IndexSourceMatcher(expectedTableName)).addColumnReferences(expectedTableName, columnReferences);
    }

    private PlanMatchPattern addColumnReferences(String expectedTableName, Map<String, String> columnReferences) {
        columnReferences.entrySet().forEach(reference -> this.withAlias((String)reference.getKey(), PlanMatchPattern.columnReference(expectedTableName, (String)reference.getValue())));
        return this;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source);
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, AggregationNode.Step step, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new AggregationStepMatcher(step));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(Map<String, ExpectedValueProvider<FunctionCall>> aggregations, Predicate<AggregationNode> predicate, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new PredicateMatcher<AggregationNode>(predicate));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((String)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, Map<Symbol, Symbol> masks, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        return PlanMatchPattern.aggregation(groupingSets, aggregations, (List<String>)ImmutableList.of(), masks, groupId, step, source);
    }

    public static PlanMatchPattern aggregation(GroupingSetDescriptor groupingSets, Map<Optional<String>, ExpectedValueProvider<FunctionCall>> aggregations, List<String> preGroupedSymbols, Map<Symbol, Symbol> masks, Optional<Symbol> groupId, AggregationNode.Step step, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(AggregationNode.class, source).with(new AggregationMatcher(groupingSets, preGroupedSymbols, masks, groupId, step));
        aggregations.entrySet().forEach(aggregation -> result.withAlias((Optional)aggregation.getKey(), (RvalueMatcher)new AggregationFunctionMatcher((ExpectedValueProvider)aggregation.getValue())));
        return result;
    }

    public static PlanMatchPattern distinctLimit(long limit, List<String> distinctSymbols, PlanMatchPattern source) {
        return PlanMatchPattern.node(DistinctLimitNode.class, source).with(new DistinctLimitMatcher(limit, PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.empty()));
    }

    public static PlanMatchPattern distinctLimit(long limit, List<String> distinctSymbols, String hashSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(DistinctLimitNode.class, source).with(new DistinctLimitMatcher(limit, PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.of(new SymbolAlias(hashSymbol))));
    }

    public static PlanMatchPattern markDistinct(String markerSymbol, List<String> distinctSymbols, PlanMatchPattern source) {
        return PlanMatchPattern.node(MarkDistinctNode.class, source).with(new MarkDistinctMatcher(new SymbolAlias(markerSymbol), PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.empty()));
    }

    public static PlanMatchPattern markDistinct(String markerSymbol, List<String> distinctSymbols, String hashSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(MarkDistinctNode.class, source).with(new MarkDistinctMatcher(new SymbolAlias(markerSymbol), PlanMatchPattern.toSymbolAliases(distinctSymbols), Optional.of(new SymbolAlias(hashSymbol))));
    }

    public static ExpectedValueProvider<WindowNode.Frame> windowFrame(WindowFrame.Type type, FrameBound.Type startType, Optional<String> startValue, FrameBound.Type endType, Optional<String> endValue) {
        return new WindowFrameProvider(type, startType, startValue.map(SymbolAlias::new), endType, endValue.map(SymbolAlias::new));
    }

    public static PlanMatchPattern window(Consumer<WindowMatcher.Builder> handler, PlanMatchPattern source) {
        WindowMatcher.Builder builder = new WindowMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern rowNumber(Consumer<RowNumberMatcher.Builder> handler, PlanMatchPattern source) {
        RowNumberMatcher.Builder builder = new RowNumberMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern topNRowNumber(Consumer<TopNRowNumberMatcher.Builder> handler, PlanMatchPattern source) {
        TopNRowNumberMatcher.Builder builder = new TopNRowNumberMatcher.Builder(source);
        handler.accept(builder);
        return builder.build();
    }

    public static PlanMatchPattern sort(PlanMatchPattern source) {
        return PlanMatchPattern.node(SortNode.class, source);
    }

    public static PlanMatchPattern sort(List<Ordering> orderBy, PlanMatchPattern source) {
        return PlanMatchPattern.node(SortNode.class, source).with(new SortMatcher(orderBy));
    }

    public static PlanMatchPattern topN(long count, List<Ordering> orderBy, PlanMatchPattern source) {
        return PlanMatchPattern.topN(count, orderBy, TopNNode.Step.SINGLE, source);
    }

    public static PlanMatchPattern topN(long count, List<Ordering> orderBy, TopNNode.Step step, PlanMatchPattern source) {
        return PlanMatchPattern.node(TopNNode.class, source).with(new TopNMatcher(count, orderBy, step));
    }

    public static PlanMatchPattern output(PlanMatchPattern source) {
        return PlanMatchPattern.node(OutputNode.class, source);
    }

    public static PlanMatchPattern output(List<String> outputs, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.output(source);
        result.withOutputs(outputs);
        return result;
    }

    public static PlanMatchPattern strictOutput(List<String> outputs, PlanMatchPattern source) {
        return PlanMatchPattern.output(outputs, source).withExactOutputs(outputs);
    }

    public static PlanMatchPattern project(PlanMatchPattern source) {
        return PlanMatchPattern.node(ProjectNode.class, source);
    }

    public static PlanMatchPattern project(Map<String, ExpressionMatcher> assignments, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.project(source);
        assignments.entrySet().forEach(assignment -> result.withAlias((String)assignment.getKey(), (RvalueMatcher)assignment.getValue()));
        return result;
    }

    public static PlanMatchPattern identityProject(PlanMatchPattern source) {
        return PlanMatchPattern.node(ProjectNode.class, source).with(new IdentityProjectionMatcher());
    }

    public static PlanMatchPattern strictProject(Map<String, ExpressionMatcher> assignments, PlanMatchPattern source) {
        return PlanMatchPattern.project(assignments, source).withExactAssignedOutputs(assignments.values()).withExactAssignments(assignments.values());
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.semiJoin(sourceSymbolAlias, filteringSymbolAlias, outputAlias, Optional.empty(), source, filtering);
    }

    public static PlanMatchPattern semiJoin(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, Optional<SemiJoinNode.DistributionType> distributionType, PlanMatchPattern source, PlanMatchPattern filtering) {
        return PlanMatchPattern.node(SemiJoinNode.class, source, filtering).with(new SemiJoinMatcher(sourceSymbolAlias, filteringSymbolAlias, outputAlias, distributionType));
    }

    public static PlanMatchPattern join(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> expectedEquiCriteria, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.join(joinType, expectedEquiCriteria, Optional.empty(), left, right);
    }

    public static PlanMatchPattern join(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> expectedEquiCriteria, Optional<String> expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.join(joinType, expectedEquiCriteria, expectedFilter, Optional.empty(), Optional.empty(), left, right);
    }

    public static PlanMatchPattern join(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> expectedEquiCriteria, Optional<String> expectedFilter, Optional<JoinNode.DistributionType> expectedDistributionType, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.join(joinType, expectedEquiCriteria, expectedFilter, expectedDistributionType, Optional.empty(), left, right);
    }

    public static PlanMatchPattern join(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> expectedEquiCriteria, Optional<String> expectedFilter, Optional<JoinNode.DistributionType> expectedDistributionType, Optional<Boolean> expectedSpillable, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(JoinNode.class, left, right).with(new JoinMatcher(joinType, expectedEquiCriteria, expectedFilter.map(predicate -> ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(predicate, new ParsingOptions()))), expectedDistributionType, expectedSpillable, Optional.empty()));
    }

    public static PlanMatchPattern join(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> expectedEquiCriteria, Map<String, String> expectedDynamicFilter, Optional<String> expectedStaticFilter, PlanMatchPattern leftSource, PlanMatchPattern right, Metadata metadata) {
        Map expectedDynamicFilterAliases = (Map)expectedDynamicFilter.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new SymbolAlias((String)entry.getKey()), entry -> new SymbolAlias((String)entry.getValue())));
        DynamicFilterMatcher dynamicFilterMatcher = new DynamicFilterMatcher(metadata, expectedDynamicFilterAliases, expectedStaticFilter.map(predicate -> ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(predicate, new ParsingOptions()))));
        JoinMatcher joinMatcher = new JoinMatcher(joinType, expectedEquiCriteria, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(dynamicFilterMatcher));
        return PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, leftSource).with(dynamicFilterMatcher)), right).with(joinMatcher);
    }

    public static PlanMatchPattern spatialJoin(String expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.spatialJoin(expectedFilter, Optional.empty(), left, right);
    }

    public static PlanMatchPattern spatialJoin(String expectedFilter, Optional<String> kdbTree, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.spatialJoin(expectedFilter, kdbTree, Optional.empty(), left, right);
    }

    public static PlanMatchPattern spatialJoin(String expectedFilter, Optional<String> kdbTree, Optional<List<String>> outputSymbols, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(SpatialJoinNode.class, left, right).with(new SpatialJoinMatcher(SpatialJoinNode.Type.INNER, ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedFilter, new ParsingOptions())), kdbTree, outputSymbols));
    }

    public static PlanMatchPattern spatialLeftJoin(String expectedFilter, PlanMatchPattern left, PlanMatchPattern right) {
        return PlanMatchPattern.node(SpatialJoinNode.class, left, right).with(new SpatialJoinMatcher(SpatialJoinNode.Type.LEFT, ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedFilter, new ParsingOptions())), Optional.empty(), Optional.empty()));
    }

    public static PlanMatchPattern unnest(PlanMatchPattern source) {
        return PlanMatchPattern.node(UnnestNode.class, source);
    }

    public static PlanMatchPattern unnest(List<String> replicateSymbols, List<UnnestMapping> mappings, PlanMatchPattern source) {
        return PlanMatchPattern.unnest(replicateSymbols, mappings, Optional.empty(), JoinNode.Type.INNER, Optional.empty(), source);
    }

    public static PlanMatchPattern unnest(List<String> replicateSymbols, List<UnnestMapping> mappings, Optional<String> ordinalitySymbol, JoinNode.Type type, Optional<String> filter, PlanMatchPattern source) {
        PlanMatchPattern result = PlanMatchPattern.node(UnnestNode.class, source).with(new UnnestMatcher(replicateSymbols, mappings, ordinalitySymbol, type, filter.map(predicate -> ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(predicate, new ParsingOptions())))));
        mappings.forEach(mapping -> {
            for (int i = 0; i < mapping.getOutputs().size(); ++i) {
                result.withAlias(mapping.getOutputs().get(i), (RvalueMatcher)new UnnestedSymbolMatcher(mapping.getInput(), i));
            }
        });
        ordinalitySymbol.ifPresent(symbol -> result.withAlias((String)symbol, (RvalueMatcher)new OrdinalitySymbolMatcher()));
        return result;
    }

    public static PlanMatchPattern exchange(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExchangeNode.class, sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, (List<Ordering>)ImmutableList.of(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, orderBy, (Set<String>)ImmutableSet.of(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, Set<String> partitionedBy, PlanMatchPattern ... sources) {
        return PlanMatchPattern.exchange(scope, type, orderBy, partitionedBy, Optional.empty(), sources);
    }

    public static PlanMatchPattern exchange(ExchangeNode.Scope scope, ExchangeNode.Type type, List<Ordering> orderBy, Set<String> partitionedBy, Optional<List<List<String>>> inputs, PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExchangeNode.class, sources).with(new ExchangeMatcher(scope, type, orderBy, partitionedBy, inputs));
    }

    public static PlanMatchPattern union(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(UnionNode.class, sources);
    }

    public static PlanMatchPattern assignUniqueId(String uniqueSymbolAlias, PlanMatchPattern source) {
        return PlanMatchPattern.node(AssignUniqueId.class, source).withAlias(uniqueSymbolAlias, (RvalueMatcher)new AssignUniqueIdMatcher());
    }

    public static PlanMatchPattern intersect(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(IntersectNode.class, sources);
    }

    public static PlanMatchPattern except(PlanMatchPattern ... sources) {
        return PlanMatchPattern.node(ExceptNode.class, sources);
    }

    public static ExpectedValueProvider<JoinNode.EquiJoinClause> equiJoinClause(String left, String right) {
        return new EquiJoinClauseProvider(new SymbolAlias(left), new SymbolAlias(right));
    }

    public static SymbolAlias symbol(String alias) {
        return new SymbolAlias(alias);
    }

    public static PlanMatchPattern filter(String expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.filter(ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expectedPredicate, new ParsingOptions())), source);
    }

    public static PlanMatchPattern filter(Expression expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.node(FilterNode.class, source).with(new FilterMatcher(expectedPredicate, Optional.empty()));
    }

    public static PlanMatchPattern filter(Expression expectedPredicate, Expression dynamicFilter, PlanMatchPattern source) {
        return PlanMatchPattern.node(FilterNode.class, source).with(new FilterMatcher(expectedPredicate, Optional.of(dynamicFilter)));
    }

    public static PlanMatchPattern apply(List<String> correlationSymbolAliases, Map<String, ExpressionMatcher> subqueryAssignments, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        PlanMatchPattern result = PlanMatchPattern.node(ApplyNode.class, inputPattern, subqueryPattern).with(new CorrelationMatcher(correlationSymbolAliases));
        subqueryAssignments.entrySet().forEach(assignment -> result.withAlias((String)assignment.getKey(), (RvalueMatcher)assignment.getValue()));
        return result;
    }

    public static PlanMatchPattern correlatedJoin(List<String> correlationSymbolAliases, PlanMatchPattern inputPattern, PlanMatchPattern subqueryPattern) {
        return PlanMatchPattern.node(CorrelatedJoinNode.class, inputPattern, subqueryPattern).with(new CorrelationMatcher(correlationSymbolAliases));
    }

    public static PlanMatchPattern groupId(List<List<String>> groupingSets, String groupIdSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.groupId(groupingSets, (List<String>)ImmutableList.of(), groupIdSymbol, source);
    }

    public static PlanMatchPattern groupId(List<List<String>> groupingSets, List<String> aggregationArguments, String groupIdSymbol, PlanMatchPattern source) {
        return PlanMatchPattern.node(GroupIdNode.class, source).with(new GroupIdMatcher(groupingSets, aggregationArguments, groupIdSymbol));
    }

    private static PlanMatchPattern values(Map<String, Integer> aliasToIndex, Optional<Integer> expectedOutputSymbolCount, Optional<List<List<Expression>>> expectedRows) {
        return PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]).with(new ValuesMatcher(aliasToIndex, expectedOutputSymbolCount, expectedRows));
    }

    private static PlanMatchPattern values(List<String> aliases, Optional<List<List<Expression>>> expectedRows) {
        return PlanMatchPattern.values((Map<String, Integer>)Maps.uniqueIndex(IntStream.range(0, aliases.size()).boxed().iterator(), aliases::get), Optional.of(aliases.size()), expectedRows);
    }

    public static PlanMatchPattern values(Map<String, Integer> aliasToIndex) {
        return PlanMatchPattern.values(aliasToIndex, Optional.empty(), Optional.empty());
    }

    public static PlanMatchPattern values(String ... aliases) {
        return PlanMatchPattern.values((List<String>)ImmutableList.copyOf((Object[])aliases));
    }

    public static PlanMatchPattern values(List<String> aliases, List<List<Expression>> expectedRows) {
        return PlanMatchPattern.values(aliases, Optional.of(expectedRows));
    }

    public static PlanMatchPattern values(List<String> aliases) {
        return PlanMatchPattern.values(aliases, Optional.empty());
    }

    public static PlanMatchPattern offset(long rowCount, PlanMatchPattern source) {
        return PlanMatchPattern.node(OffsetNode.class, source).with(new OffsetMatcher(rowCount));
    }

    public static PlanMatchPattern limit(long limit, PlanMatchPattern source) {
        return PlanMatchPattern.limit(limit, (List<Ordering>)ImmutableList.of(), false, source);
    }

    public static PlanMatchPattern limit(long limit, List<Ordering> tiesResolvers, PlanMatchPattern source) {
        return PlanMatchPattern.limit(limit, tiesResolvers, false, source);
    }

    public static PlanMatchPattern limit(long limit, List<Ordering> tiesResolvers, boolean partial, PlanMatchPattern source) {
        return PlanMatchPattern.node(LimitNode.class, source).with(new LimitMatcher(limit, tiesResolvers, partial));
    }

    public static PlanMatchPattern enforceSingleRow(PlanMatchPattern source) {
        return PlanMatchPattern.node(EnforceSingleRowNode.class, source);
    }

    public static PlanMatchPattern tableWriter(List<String> columns, List<String> columnNames, PlanMatchPattern source) {
        return PlanMatchPattern.node(TableWriterNode.class, source).with(new TableWriterMatcher(columns, columnNames));
    }

    public PlanMatchPattern(List<PlanMatchPattern> sourcePatterns) {
        Objects.requireNonNull(sourcePatterns, "sourcePatterns are null");
        this.sourcePatterns = ImmutableList.copyOf(sourcePatterns);
    }

    List<PlanMatchingState> shapeMatches(PlanNode node) {
        ImmutableList.Builder states = ImmutableList.builder();
        if (this.anyTree) {
            int sourcesCount = node.getSources().size();
            if (sourcesCount > 1) {
                states.add((Object)new PlanMatchingState(Collections.nCopies(sourcesCount, this)));
            } else {
                states.add((Object)new PlanMatchingState((List<PlanMatchPattern>)ImmutableList.of((Object)this)));
            }
        }
        if (node instanceof GroupReference) {
            if (this.sourcePatterns.isEmpty() && this.shapeMatchesMatchers(node)) {
                states.add((Object)new PlanMatchingState((List<PlanMatchPattern>)ImmutableList.of()));
            }
        } else if (node.getSources().size() == this.sourcePatterns.size() && this.shapeMatchesMatchers(node)) {
            states.add((Object)new PlanMatchingState(this.sourcePatterns));
        }
        return states.build();
    }

    private boolean shapeMatchesMatchers(PlanNode node) {
        return this.matchers.stream().allMatch(it -> it.shapeMatches(node));
    }

    MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        SymbolAliases.Builder newAliases = SymbolAliases.builder();
        for (Matcher matcher : this.matchers) {
            MatchResult matchResult = matcher.detailMatches(node, stats, session, metadata, symbolAliases);
            if (!matchResult.isMatch()) {
                return MatchResult.NO_MATCH;
            }
            newAliases.putAll(matchResult.getAliases());
        }
        return MatchResult.match(newAliases.build());
    }

    public PlanMatchPattern with(Matcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public PlanMatchPattern withAlias(String alias) {
        return this.withAlias(Optional.of(alias), (RvalueMatcher)new AliasPresent(alias));
    }

    public PlanMatchPattern withAlias(String alias, RvalueMatcher matcher) {
        return this.withAlias(Optional.of(alias), matcher);
    }

    public PlanMatchPattern withAlias(Optional<String> alias, RvalueMatcher matcher) {
        this.matchers.add(new AliasMatcher(alias, matcher));
        return this;
    }

    public PlanMatchPattern withNumberOfOutputColumns(int numberOfSymbols) {
        this.matchers.add(new SymbolCardinalityMatcher(numberOfSymbols));
        return this;
    }

    public PlanMatchPattern withExactOutputs(String ... expectedAliases) {
        return this.withExactOutputs((List<String>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactOutputs(List<String> expectedAliases) {
        this.matchers.add(new StrictSymbolsMatcher(StrictSymbolsMatcher.actualOutputs(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withExactAssignedOutputs(RvalueMatcher ... expectedAliases) {
        return this.withExactAssignedOutputs((Collection<? extends RvalueMatcher>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactAssignedOutputs(Collection<? extends RvalueMatcher> expectedAliases) {
        this.matchers.add(new StrictAssignedSymbolsMatcher(StrictSymbolsMatcher.actualOutputs(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withExactAssignments(RvalueMatcher ... expectedAliases) {
        return this.withExactAssignments((Collection<? extends RvalueMatcher>)ImmutableList.copyOf((Object[])expectedAliases));
    }

    public PlanMatchPattern withExactAssignments(Collection<? extends RvalueMatcher> expectedAliases) {
        this.matchers.add(new StrictAssignedSymbolsMatcher(StrictAssignedSymbolsMatcher.actualAssignments(), expectedAliases));
        return this;
    }

    public PlanMatchPattern withOutputRowCount(double expectedOutputRowCount) {
        this.matchers.add(new StatsOutputRowCountMatcher(expectedOutputRowCount));
        return this;
    }

    public static RvalueMatcher columnReference(String tableName, String columnName) {
        return new ColumnReference(tableName, columnName);
    }

    public static ExpressionMatcher expression(String expression) {
        return new ExpressionMatcher(expression);
    }

    public static ExpressionMatcher expression(Expression expression) {
        return new ExpressionMatcher(expression);
    }

    public PlanMatchPattern withOutputs(String ... aliases) {
        return this.withOutputs((List<String>)ImmutableList.copyOf((Object[])aliases));
    }

    public PlanMatchPattern withOutputs(List<String> aliases) {
        this.matchers.add(new OutputMatcher(aliases));
        return this;
    }

    public PlanMatchPattern matchToAnyNodeTree() {
        this.anyTree = true;
        return this;
    }

    public boolean isTerminated() {
        return this.sourcePatterns.isEmpty();
    }

    public static PlanTestSymbol anySymbol() {
        return new AnySymbol();
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args));
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, List<String> args, List<Ordering> orderBy) {
        return new FunctionCallProvider(QualifiedName.of((String)name), PlanMatchPattern.toSymbolAliases(args), orderBy);
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, Optional<WindowFrame> frame, List<String> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), frame, false, PlanMatchPattern.toSymbolAliases(args));
    }

    public static ExpectedValueProvider<FunctionCall> functionCall(String name, boolean distinct, List<PlanTestSymbol> args) {
        return new FunctionCallProvider(QualifiedName.of((String)name), distinct, args);
    }

    public static List<Expression> toSymbolReferences(List<PlanTestSymbol> aliases, SymbolAliases symbolAliases) {
        return (List)aliases.stream().map(arg -> arg.toSymbol(symbolAliases).toSymbolReference()).collect(ImmutableList.toImmutableList());
    }

    private static List<PlanTestSymbol> toSymbolAliases(List<String> aliases) {
        return (List)aliases.stream().map(PlanMatchPattern::symbol).collect(ImmutableList.toImmutableList());
    }

    public static ExpectedValueProvider<WindowNode.Specification> specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
        return new SpecificationProvider((List)partitionBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()), (List)orderBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()), (Map)orderings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new SymbolAlias((String)entry.getKey()), Map.Entry::getValue)));
    }

    public static Ordering sort(String field, SortItem.Ordering ordering, SortItem.NullOrdering nullOrdering) {
        return new Ordering(field, ordering, nullOrdering);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    private void toString(StringBuilder builder, int indent) {
        Preconditions.checkState((this.matchers.stream().filter(PlanNodeMatcher.class::isInstance).count() <= 1L ? 1 : 0) != 0);
        builder.append(PlanMatchPattern.indentString(indent)).append("- ");
        if (this.anyTree) {
            builder.append("anyTree");
        } else {
            builder.append("node");
        }
        Optional<PlanNodeMatcher> planNodeMatcher = this.matchers.stream().filter(PlanNodeMatcher.class::isInstance).map(PlanNodeMatcher.class::cast).findFirst();
        if (planNodeMatcher.isPresent()) {
            builder.append("(").append(planNodeMatcher.get().getNodeClass().getSimpleName()).append(")");
        }
        builder.append("\n");
        List matchersToPrint = (List)this.matchers.stream().filter(matcher -> !(matcher instanceof PlanNodeMatcher)).collect(ImmutableList.toImmutableList());
        for (Matcher matcher2 : matchersToPrint) {
            builder.append(PlanMatchPattern.indentString(indent + 1)).append(matcher2.toString()).append("\n");
        }
        for (PlanMatchPattern pattern : this.sourcePatterns) {
            pattern.toString(builder, indent + 1);
        }
    }

    private static String indentString(int indent) {
        return "    ".repeat(indent);
    }

    public static GroupingSetDescriptor globalAggregation() {
        return PlanMatchPattern.singleGroupingSet(new String[0]);
    }

    public static GroupingSetDescriptor singleGroupingSet(String ... groupingKeys) {
        return PlanMatchPattern.singleGroupingSet((List<String>)ImmutableList.copyOf((Object[])groupingKeys));
    }

    public static GroupingSetDescriptor singleGroupingSet(List<String> groupingKeys) {
        ImmutableSet globalGroupingSets = groupingKeys.size() == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
        return new GroupingSetDescriptor(groupingKeys, 1, (Set<Integer>)globalGroupingSets);
    }

    public static class Ordering {
        private final String field;
        private final SortItem.Ordering ordering;
        private final SortItem.NullOrdering nullOrdering;

        private Ordering(String field, SortItem.Ordering ordering, SortItem.NullOrdering nullOrdering) {
            this.field = field;
            this.ordering = ordering;
            this.nullOrdering = nullOrdering;
        }

        public String getField() {
            return this.field;
        }

        public SortItem.Ordering getOrdering() {
            return this.ordering;
        }

        public SortItem.NullOrdering getNullOrdering() {
            return this.nullOrdering;
        }

        public SortOrder getSortOrder() {
            Preconditions.checkState((this.nullOrdering != SortItem.NullOrdering.UNDEFINED ? 1 : 0) != 0, (Object)"nullOrdering is undefined");
            if (this.ordering == SortItem.Ordering.ASCENDING) {
                if (this.nullOrdering == SortItem.NullOrdering.FIRST) {
                    return SortOrder.ASC_NULLS_FIRST;
                }
                return SortOrder.ASC_NULLS_LAST;
            }
            Preconditions.checkState((this.ordering == SortItem.Ordering.DESCENDING ? 1 : 0) != 0);
            if (this.nullOrdering == SortItem.NullOrdering.FIRST) {
                return SortOrder.DESC_NULLS_FIRST;
            }
            return SortOrder.DESC_NULLS_LAST;
        }

        public String toString() {
            String result = this.field + " " + this.ordering;
            if (this.nullOrdering != SortItem.NullOrdering.UNDEFINED) {
                result = result + " NULLS " + this.nullOrdering;
            }
            return result;
        }
    }

    public static class UnnestMapping {
        private final String input;
        private final List<String> outputs;

        private UnnestMapping(String input, List<String> outputs) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.outputs = Objects.requireNonNull(outputs, "outputs is null");
        }

        public static UnnestMapping unnestMapping(String input, List<String> outputs) {
            return new UnnestMapping(input, outputs);
        }

        public String getInput() {
            return this.input;
        }

        public List<String> getOutputs() {
            return this.outputs;
        }
    }

    public static class GroupingSetDescriptor {
        private final List<String> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        private GroupingSetDescriptor(List<String> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
            this.groupingKeys = groupingKeys;
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = globalGroupingSets;
        }

        public List<String> getGroupingKeys() {
            return this.groupingKeys;
        }

        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("keys", this.groupingKeys).add("count", this.groupingSetCount).add("globalSets", this.globalGroupingSets).toString();
        }
    }
}

