/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class TableScanMatcher
implements Matcher {
    private final String expectedTableName;
    private final Optional<Map<String, Domain>> expectedConstraint;
    private final Optional<Boolean> hasTableLayout;

    private TableScanMatcher(String expectedTableName, Optional<Map<String, Domain>> expectedConstraint, Optional<Boolean> hasTableLayout) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        this.expectedConstraint = Objects.requireNonNull(expectedConstraint, "expectedConstraint is null");
        this.hasTableLayout = Objects.requireNonNull(hasTableLayout, "hasTableLayout is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableScanNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableScanNode tableScanNode = (TableScanNode)node;
        TableMetadata tableMetadata = metadata.getTableMetadata(session, tableScanNode.getTable());
        String actualTableName = tableMetadata.getTable().getTableName();
        return new MatchResult(this.expectedTableName.equalsIgnoreCase(actualTableName) && (this.expectedConstraint.isEmpty() || Util.domainsMatch(this.expectedConstraint, (TupleDomain<ColumnHandle>)tableScanNode.getEnforcedConstraint(), tableScanNode.getTable(), session, metadata)));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("expectedTableName", (Object)this.expectedTableName).add("expectedConstraint", this.expectedConstraint.orElse(null)).add("hasTableLayout", this.hasTableLayout.orElse(null)).toString();
    }

    public static Builder builder(String expectedTableName) {
        return new Builder(expectedTableName);
    }

    public static PlanMatchPattern create(String expectedTableName) {
        return TableScanMatcher.builder(expectedTableName).build();
    }

    public static class Builder {
        private final String expectedTableName;
        private Optional<Map<String, Domain>> expectedConstraint = Optional.empty();
        private Optional<Boolean> hasTableLayout = Optional.empty();

        private Builder(String expectedTableName) {
            this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        }

        public Builder expectedConstraint(Map<String, Domain> expectedConstraint) {
            this.expectedConstraint = Optional.of(expectedConstraint);
            return this;
        }

        public Builder hasTableLayout() {
            this.hasTableLayout = Optional.of(true);
            return this;
        }

        PlanMatchPattern build() {
            PlanMatchPattern result = PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new TableScanMatcher(this.expectedTableName, this.expectedConstraint, this.hasTableLayout));
            return result;
        }
    }
}

