/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIterativeOptimizer {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1").setSystemProperty("iterative_optimizer_timeout", "1ms");
        this.queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }

    @Test(timeOut=1000L)
    public void optimizerTimeoutsOnNonConvergingPlan() {
        IterativeOptimizer optimizer = new IterativeOptimizer(new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new AddIdentityOverTableScan(), (Object)new RemoveRedundantIdentityProjections()));
        try {
            this.queryRunner.inTransaction(arg_0 -> this.lambda$optimizerTimeoutsOnNonConvergingPlan$0((PlanOptimizer)optimizer, arg_0));
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.OPTIMIZER_TIMEOUT.toErrorCode());
        }
    }

    private /* synthetic */ Object lambda$optimizerTimeoutsOnNonConvergingPlan$0(PlanOptimizer optimizer, Session transactionSession) {
        this.queryRunner.createPlan(transactionSession, "SELECT nationkey FROM nation", (List)ImmutableList.of((Object)optimizer), WarningCollector.NOOP);
        Assert.fail((String)"The optimizer should not converge");
        return null;
    }

    private static class AddIdentityOverTableScan
    implements Rule<TableScanNode> {
        private AddIdentityOverTableScan() {
        }

        public Pattern<TableScanNode> getPattern() {
            return Patterns.tableScan();
        }

        public Rule.Result apply(TableScanNode tableScan, Captures captures, Rule.Context context) {
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)tableScan, Assignments.identity((Iterable)tableScan.getOutputSymbols())));
        }
    }
}

