/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.AbstractMockMetadata;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.RuleIndex;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRuleIndex {
    private final PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());

    @Test
    public void testWithPlanNodeHierarchy() {
        NoOpRule projectRule1 = new NoOpRule(Pattern.typeOf(ProjectNode.class));
        NoOpRule projectRule2 = new NoOpRule(Pattern.typeOf(ProjectNode.class));
        NoOpRule filterRule = new NoOpRule(Pattern.typeOf(FilterNode.class));
        NoOpRule anyRule = new NoOpRule(Pattern.any());
        RuleIndex ruleIndex = RuleIndex.builder().register(projectRule1).register(projectRule2).register(filterRule).register(anyRule).build();
        ProjectNode projectNode = this.planBuilder.project(Assignments.of(), (PlanNode)this.planBuilder.values(new Symbol[0]));
        FilterNode filterNode = this.planBuilder.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)this.planBuilder.values(new Symbol[0]));
        ValuesNode valuesNode = this.planBuilder.values(new Symbol[0]);
        Assert.assertEquals(ruleIndex.getCandidates((Object)projectNode).collect(Collectors.toSet()), (Set)ImmutableSet.of(projectRule1, projectRule2, anyRule));
        Assert.assertEquals(ruleIndex.getCandidates((Object)filterNode).collect(Collectors.toSet()), (Set)ImmutableSet.of(filterRule, anyRule));
        Assert.assertEquals(ruleIndex.getCandidates((Object)valuesNode).collect(Collectors.toSet()), (Set)ImmutableSet.of(anyRule));
    }

    @Test
    public void testInterfacesHierarchy() {
        NoOpRule a = new NoOpRule(Pattern.typeOf(A.class));
        NoOpRule b = new NoOpRule(Pattern.typeOf(B.class));
        NoOpRule ab = new NoOpRule(Pattern.typeOf(AB.class));
        RuleIndex ruleIndex = RuleIndex.builder().register(a).register(b).register(ab).build();
        Assert.assertEquals(ruleIndex.getCandidates((Object)new A(){}).collect(Collectors.toSet()), (Set)ImmutableSet.of(a));
        Assert.assertEquals(ruleIndex.getCandidates((Object)new B(){}).collect(Collectors.toSet()), (Set)ImmutableSet.of(b));
        Assert.assertEquals(ruleIndex.getCandidates((Object)new AB()).collect(Collectors.toSet()), (Set)ImmutableSet.of(ab, a, b));
    }

    private static class AB
    implements A,
    B {
        private AB() {
        }
    }

    private static interface B {
    }

    private static interface A {
    }

    private static class NoOpRule<T>
    implements Rule<T> {
        private final Pattern<T> pattern;

        private NoOpRule(Pattern<T> pattern) {
            this.pattern = pattern;
        }

        public Pattern<T> getPattern() {
            return this.pattern;
        }

        public Rule.Result apply(T node, Captures captures, Rule.Context context) {
            return Rule.Result.empty();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pattern", this.pattern).toString();
        }
    }
}

