/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.RowNumberSymbolMatcher;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ImplementOffset;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestImplementOffset
extends BaseRuleTest {
    public TestImplementOffset() {
        super(new Plugin[0]);
    }

    @Test
    public void testReplaceOffsetOverValues() {
        this.tester().assertThat((Rule<?>)new ImplementOffset()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.offset(2L, (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)new ExpressionMatcher("a"), (Object)"b", (Object)new ExpressionMatcher("b")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.values("a", "b")).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testReplaceOffsetOverSort() {
        this.tester().assertThat((Rule<?>)new ImplementOffset()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.offset(2L, (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)new ExpressionMatcher("a"), (Object)"b", (Object)new ExpressionMatcher("b")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }
}

