/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.InlineProjections;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestInlineProjections
extends BaseRuleTest {
    private static final RowType MSG_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)));

    public TestInlineProjections() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("identity"), PlanBuilder.expression("symbol")).put(p.symbol("multi_complex_1"), PlanBuilder.expression("complex + 1")).put(p.symbol("multi_complex_2"), PlanBuilder.expression("complex + 2")).put(p.symbol("multi_literal_1"), PlanBuilder.expression("literal + 1")).put(p.symbol("multi_literal_2"), PlanBuilder.expression("literal + 2")).put(p.symbol("single_complex"), PlanBuilder.expression("complex_2 + 2")).put(p.symbol("try"), PlanBuilder.expression("try(complex / literal)")).put(p.symbol("msg_xx"), PlanBuilder.expression("z + 1")).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("symbol"), PlanBuilder.expression("x")).put(p.symbol("complex"), PlanBuilder.expression("x * 2")).put(p.symbol("literal"), PlanBuilder.expression("1")).put(p.symbol("complex_2"), PlanBuilder.expression("x - 1")).put(p.symbol("z"), PlanBuilder.expression("msg.x")).build(), (PlanNode)p.values(p.symbol("x"), p.symbol("msg", (Type)MSG_TYPE))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression("x")).put((Object)"out2", (Object)PlanMatchPattern.expression("y + 1")).put((Object)"out3", (Object)PlanMatchPattern.expression("y + 2")).put((Object)"out4", (Object)PlanMatchPattern.expression("1 + 1")).put((Object)"out5", (Object)PlanMatchPattern.expression("1 + 2")).put((Object)"out6", (Object)PlanMatchPattern.expression("x - 1 + 2")).put((Object)"out7", (Object)PlanMatchPattern.expression("try(y / 1)")).put((Object)"out8", (Object)PlanMatchPattern.expression("z + 1")).build(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x"), (Object)"y", (Object)PlanMatchPattern.expression("x * 2"), (Object)"z", (Object)PlanMatchPattern.expression("msg.x")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"msg", (Object)1)))));
    }

    @Test
    public void testEliminatesIdentityProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("single_complex"), PlanBuilder.expression("complex + 2")).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("complex"), PlanBuilder.expression("x - 1")).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression("x - 1 + 2")).build(), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0))));
    }

    @Test
    public void testIdentityProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.of((Symbol)p.symbol("output"), (Expression)PlanBuilder.expression("value")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).doesNotFire();
    }

    @Test
    public void testSubqueryProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).doesNotFire();
    }
}

