/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeExcept;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeExcept
extends BaseRuleTest {
    public TestMergeExcept() {
        super(new Plugin[0]);
    }

    @Test
    public void testFlattening() {
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            ExceptNode u1 = p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            ExceptNode u2 = p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)u2));
        }).matches(PlanMatchPattern.except(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.except(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"))));
    }

    @Test
    public void testNotFlattening() {
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            ExceptNode u2 = p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, c), (Object)u2));
        }).doesNotFire();
    }
}

