/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeIntersect;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeIntersect
extends BaseRuleTest {
    public TestMergeIntersect() {
        super(new Plugin[0]);
    }

    @Test
    public void testFlattening() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            IntersectNode u1 = p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            IntersectNode u2 = p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)u2));
        }).matches(PlanMatchPattern.intersect(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.values("a"), PlanMatchPattern.values("b")));
    }

    @Test
    public void testMixedFlattening() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            IntersectNode u1 = p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)p.values(1, d)));
        }).matches(PlanMatchPattern.intersect(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.values("d")));
    }

    @Test
    public void testNotFlattening() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
        }).doesNotFire();
    }
}

