/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeLimitWithTopN;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeLimitWithTopN
extends BaseRuleTest {
    public TestMergeLimitWithTopN() {
        super(new Plugin[0]);
    }

    @Test
    public void testMergeLimitWithTopN() {
        this.tester().assertThat((Rule<?>)new MergeLimitWithTopN()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.topN(2L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a")));
    }

    @Test
    public void testMergeLimitWithWithTiesTopN() {
        this.tester().assertThat((Rule<?>)new MergeLimitWithTopN()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(2L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.topN(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a")));
    }

    @Test
    public void doNotMergeLimitWithTies() {
        this.tester().assertThat((Rule<?>)new MergeLimitWithTopN()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.topN(2L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

