/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeLimits;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeLimits
extends BaseRuleTest {
    public TestMergeLimits() {
        super(new Plugin[0]);
    }

    @Test
    public void testMergeLimitsNoTies() {
        this.tester().assertThat((Rule<?>)new MergeLimits()).on(p -> p.limit(5L, (PlanNode)p.limit(3L, (PlanNode)p.values(new Symbol[0])))).matches(PlanMatchPattern.limit(3L, PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testMergeLimitsNoTiesTies() {
        this.tester().assertThat((Rule<?>)new MergeLimits()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(3L, (PlanNode)p.limit(5L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.limit(3L, PlanMatchPattern.values("a")));
    }

    @Test
    public void testRearrangeLimitsNoTiesTies() {
        this.tester().assertThat((Rule<?>)new MergeLimits()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(5L, (PlanNode)p.limit(3L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.limit(3L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.limit(5L, PlanMatchPattern.values("a"))));
    }

    @Test
    public void testDoNotFireParentWithTies() {
        this.tester().assertThat((Rule<?>)new MergeLimits()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(5L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.limit(3L, (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

