/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneDistinctAggregation;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneDistinctAggregation
extends BaseRuleTest {
    public TestPruneDistinctAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruning() {
        this.tester().assertThat((Rule<?>)new PruneDistinctAggregation()).on(p -> {
            Symbol a = p.symbol("a");
            AggregationNode child = p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().source((PlanNode)p.values(1, a)));
            return p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().source((PlanNode)child));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.values("a")));
    }

    @Test
    public void testNonPruning() {
        this.tester().assertThat((Rule<?>)new PruneDistinctAggregation()).on(p -> {
            Symbol a = p.symbol("a");
            AggregationNode child = p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().addAggregation(p.symbol("sum", (Type)BigintType.BIGINT), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(1, a)));
            return p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().source((PlanNode)child));
        }).doesNotFire();
    }
}

