/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneEnforceSingleRowColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneEnforceSingleRowColumns
extends BaseRuleTest {
    public TestPruneEnforceSingleRowColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneInputColumn() {
        this.tester().assertThat((Rule<?>)new PruneEnforceSingleRowColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.enforceSingleRow((PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.enforceSingleRow(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneEnforceSingleRowColumns()).on(p -> {
            Symbol a = p.symbol("a");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.enforceSingleRow((PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

