/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneExchangeColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestPruneExchangeColumns
extends BaseRuleTest {
    public TestPruneExchangeColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotPruneReferencedOutputSymbol() {
        this.tester().assertThat((Rule<?>)new PruneExchangeColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(b)).addInputsSet(b).singleDistributionPartitioningScheme(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPrunePartitioningSymbol() {
        this.tester().assertThat((Rule<?>)new PruneExchangeColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(b)).addInputsSet(b).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of((Object)a))));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneHashSymbol() {
        this.tester().assertThat((Rule<?>)new PruneExchangeColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol h = p.symbol("h");
            Symbol b = p.symbol("b");
            Symbol h1 = p.symbol("h_1");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(b, h1)).addInputsSet(b, h1).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)a, (Object)h), (List<Symbol>)ImmutableList.of((Object)a), h)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneOrderingSymbol() {
        this.tester().assertThat((Rule<?>)new PruneExchangeColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(b)).addInputsSet(b).singleDistributionPartitioningScheme(a).orderingScheme(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))));
        }).doesNotFire();
    }

    @Test
    public void testPruneUnreferencedSymbol() {
        this.tester().assertThat((Rule<?>)new PruneExchangeColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b)).addInputsSet(a, b).singleDistributionPartitioningScheme(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"a"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"))).withExactOutputs("a")));
    }

    @Test
    public void testPruneUnreferencedSymbolMultipleSources() {
        this.tester().assertThat((Rule<?>)new PruneExchangeColumns()).on(p -> {
            Symbol a1 = p.symbol("a_1");
            Symbol a2 = p.symbol("a_2");
            Symbol b1 = p.symbol("b_1");
            Symbol b2 = p.symbol("b_2");
            Symbol c1 = p.symbol("c_1");
            Symbol c2 = p.symbol("c_2");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a1}), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(b1, b2)).addInputsSet(b1, b2).addSource((PlanNode)p.values(c1, c2)).addInputsSet(c1, c2).singleDistributionPartitioningScheme(a1, a2)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"b_1"), (Object)ImmutableList.of((Object)"c_1"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_1", (Object)"b_2")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c_1", (Object)"c_2"))).withNumberOfOutputColumns(1)));
    }
}

