/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.TopNRowNumberSymbolMatcher;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneTopNRowNumberColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneTopNRowNumberColumns
extends BaseRuleTest {
    public TestPruneTopNRowNumberColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotPrunePartitioningSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTopNRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b, rowNumber}), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of((Object)a), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)b), (Map)ImmutableMap.of((Object)b, (Object)SortOrder.ASC_NULLS_FIRST)))), 5, rowNumber, Optional.empty(), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneOrderingSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTopNRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), 5, rowNumber, Optional.empty(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneHashSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTopNRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol hash = p.symbol("hash");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), 5, rowNumber, Optional.of(hash), (PlanNode)p.values(a, hash)));
        }).doesNotFire();
    }

    @Test
    public void testSourceSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), 5, rowNumber, Optional.empty(), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.topNRowNumber(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRowCountPerPartition(5), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b"))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher())));
    }

    @Test
    public void testAllSymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b, rowNumber}), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), 5, rowNumber, Optional.empty(), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testRowNumberSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), 5, rowNumber, Optional.empty(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

