/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneUnnestColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneUnnestColumns
extends BaseRuleTest {
    public TestPruneUnnestColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneOrdinalitySymbol() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, unnestedSymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"replicate_symbol", (Object)PlanMatchPattern.expression("replicate_symbol"), (Object)"unnested_symbol", (Object)PlanMatchPattern.expression("unnested_symbol")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"replicate_symbol"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("unnest_symbol", (List<String>)ImmutableList.of((Object)"unnested_symbol"))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), PlanMatchPattern.values("replicate_symbol", "unnest_symbol"))));
    }

    @Test
    public void testPruneReplicateSymbol() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{unnestedSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"unnested_symbol", (Object)PlanMatchPattern.expression("unnested_symbol"), (Object)"ordinality_symbol", (Object)PlanMatchPattern.expression("ordinality_symbol")), PlanMatchPattern.unnest((List<String>)ImmutableList.of(), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("unnest_symbol", (List<String>)ImmutableList.of((Object)"unnested_symbol"))), Optional.of("ordinality_symbol"), JoinNode.Type.INNER, Optional.empty(), PlanMatchPattern.values("replicate_symbol", "unnest_symbol"))));
    }

    @Test
    public void testDoNotPruneOrdinalitySymbolUsedInFilter() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, unnestedSymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinNode.Type.INNER, Optional.of(PlanBuilder.expression("ordinality_symbol < BIGINT '5'")), (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneReplicateSymbolUsedInFilter() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{unnestedSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinNode.Type.INNER, Optional.of(PlanBuilder.expression("replicate_symbol < BIGINT '5'")), (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneUnnestedSymbol() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).doesNotFire();
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, unnestedSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).doesNotFire();
    }
}

