/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneUnnestSourceColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneUnnestSourceColumns
extends BaseRuleTest {
    public TestPruneUnnestSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnnestSourceColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unusedSymbol = p.symbol("unused_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            return p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), (PlanNode)p.values(replicateSymbol, unnestSymbol, unusedSymbol));
        }).matches(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"replicate_symbol"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("unnest_symbol", (List<String>)ImmutableList.of((Object)"unnested_symbol"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"replicate_symbol", (Object)PlanMatchPattern.expression("replicate_symbol"), (Object)"unnest_symbol", (Object)PlanMatchPattern.expression("unnest_symbol")), PlanMatchPattern.values("replicate_symbol", "unnest_symbol", "unused_symbol"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnnestSourceColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            return p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), (PlanNode)p.values(replicateSymbol, unnestSymbol));
        }).doesNotFire();
    }
}

