/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ExtractDereferencesFromFilterAboveScan;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferenceThroughFilter;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferenceThroughJoin;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferenceThroughProject;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferenceThroughSemiJoin;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferenceThroughUnnest;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughAssignUniqueId;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughLimit;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughMarkDistinct;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughRowNumber;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughSort;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughTopN;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughTopNRowNumber;
import io.prestosql.sql.planner.iterative.rule.PushDownDereferencesThroughWindow;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.WindowFrame;
import io.prestosql.testing.TestingTransactionHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPushDownDereferencesRules
extends BaseRuleTest {
    private static final RowType ROW_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));

    public TestPushDownDereferencesRules() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughFilter(this.tester().getTypeAnalyzer())).on(p -> p.filter(PlanBuilder.expression("x > BIGINT '5'"), (PlanNode)p.values(p.symbol("x")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr_1"), (Expression)PlanBuilder.expression("cast(row(a, b) as row(f1 row(x bigint, y bigint), f2 bigint)).f1"), (Symbol)p.symbol("expr_2"), (Expression)PlanBuilder.expression("cast(row(a, b) as row(f1 row(x bigint, y bigint), f2 bigint)).f1.y")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a", (Type)ROW_TYPE), (Expression)PlanBuilder.expression("a"), (Symbol)p.symbol("b"), (Expression)PlanBuilder.expression("b")), (PlanNode)p.values(p.symbol("a", (Type)ROW_TYPE), p.symbol("b"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr", (Type)ROW_TYPE), (Expression)PlanBuilder.expression("a"), (Symbol)p.symbol("a_x"), (Expression)PlanBuilder.expression("a.x")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a", (Type)ROW_TYPE), (Expression)PlanBuilder.expression("a")), (PlanNode)p.values(p.symbol("a", (Type)ROW_TYPE))))).doesNotFire();
    }

    @Test
    public void testPushdownDereferenceThroughProject() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("msg.x")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("y"), (Symbol)p.symbol("msg", (Type)ROW_TYPE), (Expression)PlanBuilder.expression("msg")), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("y"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("msg_x")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"y", (Object)PlanMatchPattern.expression("y"), (Object)"msg", (Object)PlanMatchPattern.expression("msg")), PlanMatchPattern.values("msg", "y"))));
    }

    @Test
    public void testPushDownDereferenceThroughJoin() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughJoin(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("left_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("right_y"), PlanBuilder.expression("msg2.y")).put(p.symbol("z"), PlanBuilder.expression("z")).build(), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("unreferenced_symbol")), (PlanNode)p.values(p.symbol("msg2", (Type)ROW_TYPE), p.symbol("z")), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"left_x", (Object)PlanMatchPattern.expression("x")).put((Object)"right_y", (Object)PlanMatchPattern.expression("y")).put((Object)"z", (Object)PlanMatchPattern.expression("z")).build(), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("msg1.x"), (Object)"msg1", (Object)PlanMatchPattern.expression("msg1"), (Object)"unreferenced_symbol", (Object)PlanMatchPattern.expression("unreferenced_symbol")), PlanMatchPattern.values("msg1", "unreferenced_symbol")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"y", (Object)PlanMatchPattern.expression("msg2.y")).put((Object)"z", (Object)PlanMatchPattern.expression("z")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).build(), PlanMatchPattern.values("msg2", "z")))));
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughJoin(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("msg1.x"), (Symbol)p.symbol("expr_2"), (Expression)PlanBuilder.expression("msg2")), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg2", (Type)ROW_TYPE)), PlanBuilder.expression("msg1.x + msg2.y > BIGINT '10'"), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("msg1_x"), (Object)"expr_2", (Object)PlanMatchPattern.expression("msg2")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("msg1_x + msg2.y > BIGINT '10'"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg1_x", (Object)PlanMatchPattern.expression("msg1.x"), (Object)"msg1", (Object)PlanMatchPattern.expression("msg1")), PlanMatchPattern.values("msg1")), PlanMatchPattern.values("msg2"))));
    }

    @Test
    public void testPushdownDereferencesThroughSemiJoin() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughSemiJoin(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_x"), PlanBuilder.expression("msg2.x")).build(), (PlanNode)p.semiJoin(p.symbol("msg2", (Type)ROW_TYPE), p.symbol("filtering_msg", (Type)ROW_TYPE), p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("filtering_msg", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression("expr")).put((Object)"msg2_x", (Object)PlanMatchPattern.expression("msg2.x")).build(), PlanMatchPattern.semiJoin("msg2", "filtering_msg", "match", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("msg1.x"), (Object)"msg1", (Object)PlanMatchPattern.expression("msg1"), (Object)"msg2", (Object)PlanMatchPattern.expression("msg2")), PlanMatchPattern.values("msg1", "msg2")), PlanMatchPattern.values("filtering_msg"))));
    }

    @Test
    public void testPushdownDereferencesThroughUnnest() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughUnnest(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("msg.x")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)p.symbol("msg", (Type)ROW_TYPE)), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("arr", (Type)arrayType), (List)ImmutableList.of((Object)p.symbol("field")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("arr", (Type)arrayType))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("msg_x")), PlanMatchPattern.unnest(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"msg", (Object)PlanMatchPattern.expression("msg"), (Object)"arr", (Object)PlanMatchPattern.expression("arr")), PlanMatchPattern.values("msg", "arr")))));
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)BigintType.BIGINT), RowType.field((String)"f2", (Type)BigintType.BIGINT)});
        ArrayType nestedColumnType = new ArrayType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)BigintType.BIGINT), RowType.field((String)"f2", (Type)rowType)}));
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughUnnest(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("deref_replicate", (Type)BigintType.BIGINT), (Expression)PlanBuilder.expression("replicate.f2"), (Symbol)p.symbol("deref_unnest", (Type)BigintType.BIGINT), (Expression)PlanBuilder.expression("unnested_row.f2")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)p.symbol("replicate", (Type)rowType)), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("nested", (Type)nestedColumnType), (List)ImmutableList.of((Object)p.symbol("unnested_bigint", (Type)BigintType.BIGINT), (Object)p.symbol("unnested_row", (Type)rowType)))), (PlanNode)p.values(p.symbol("replicate", (Type)rowType), p.symbol("nested", (Type)nestedColumnType))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"deref_replicate", (Object)PlanMatchPattern.expression("symbol"), (Object)"deref_unnest", (Object)PlanMatchPattern.expression("unnested_row.f2")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"replicate", (Object)"symbol"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("nested", (List<String>)ImmutableList.of((Object)"unnested_bigint", (Object)"unnested_row"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"symbol", (Object)PlanMatchPattern.expression("replicate.f2"), (Object)"replicate", (Object)PlanMatchPattern.expression("replicate"), (Object)"nested", (Object)PlanMatchPattern.expression("nested")), PlanMatchPattern.values("replicate", "nested")))));
    }

    @Test
    public void testExtractDereferencesFromFilterAboveScan() {
        TableHandle testTable = new TableHandle(new CatalogName("local"), (ConnectorTableHandle)new TpchTableHandle("orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        RowType nestedRowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("nested"), (Type)ROW_TYPE)));
        this.tester().assertThat((Rule<?>)new ExtractDereferencesFromFilterAboveScan(this.tester().getTypeAnalyzer())).on(p -> p.filter(PlanBuilder.expression("a.nested.x != 5 AND b.y = 2 AND CAST(a.nested as JSON) is not null"), (PlanNode)p.tableScan(testTable, (List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)nestedRowType), (Object)p.symbol("b", (Type)ROW_TYPE)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("a", (Type)nestedRowType), (Object)new TpchColumnHandle("a", (Type)nestedRowType), (Object)p.symbol("b", (Type)ROW_TYPE), (Object)new TpchColumnHandle("b", (Type)ROW_TYPE))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("expr != 5 AND expr_0 = 2 AND CAST(expr_1 as JSON) is not null", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("a.nested.x"), (Object)"expr_0", (Object)PlanMatchPattern.expression("b.y"), (Object)"expr_1", (Object)PlanMatchPattern.expression("a.nested"), (Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)testTable.getConnectorHandle()), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"a", (Object)Predicates.equalTo((Object)new TpchColumnHandle("a", (Type)nestedRowType)), (Object)"b", (Object)Predicates.equalTo((Object)new TpchColumnHandle("b", (Type)ROW_TYPE))))))));
    }

    @Test
    public void testPushdownDereferenceThroughFilter() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughFilter(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr", (Type)BigintType.BIGINT), (Expression)PlanBuilder.expression("msg.x"), (Symbol)p.symbol("expr_2", (Type)BigintType.BIGINT), (Expression)PlanBuilder.expression("msg2.x")), (PlanNode)p.filter(PlanBuilder.expression("msg.x <> 'foo' AND msg2 is NOT NULL"), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("msg_x"), (Object)"expr_2", (Object)PlanMatchPattern.expression("msg2.x")), PlanMatchPattern.filter("msg_x <> 'foo' AND msg2 is NOT NULL", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression("msg.x"), (Object)"msg", (Object)PlanMatchPattern.expression("msg"), (Object)"msg2", (Object)PlanMatchPattern.expression("msg2")), PlanMatchPattern.values("msg", "msg2")))));
    }

    @Test
    public void testPushDownDereferenceThroughLimit() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughLimit(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_y"), PlanBuilder.expression("msg2.y")).put(p.symbol("z"), PlanBuilder.expression("z")).build(), (PlanNode)p.limit(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("z"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression("x")).put((Object)"msg2_y", (Object)PlanMatchPattern.expression("msg2.y")).put((Object)"z", (Object)PlanMatchPattern.expression("z")).build(), PlanMatchPattern.limit(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("msg2", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"x", (Object)PlanMatchPattern.expression("msg1.x")).put((Object)"z", (Object)PlanMatchPattern.expression("z")).put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).build(), PlanMatchPattern.values("msg1", "msg2", "z")))));
    }

    @Test
    public void testPushDownDereferenceThroughSort() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughSort(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg_x"), PlanBuilder.expression("msg.x")).put(p.symbol("msg_y"), PlanBuilder.expression("msg.y")).put(p.symbol("z"), PlanBuilder.expression("z")).build(), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("z"), (Object)p.symbol("msg", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("z"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughSort(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg_x"), PlanBuilder.expression("msg.x")).put(p.symbol("z"), PlanBuilder.expression("z")).build(), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("z")), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("z"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg_x", (Object)PlanMatchPattern.expression("x")).put((Object)"z", (Object)PlanMatchPattern.expression("z")).build(), PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("z", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"x", (Object)PlanMatchPattern.expression("msg.x")).put((Object)"z", (Object)PlanMatchPattern.expression("z")).put((Object)"msg", (Object)PlanMatchPattern.expression("msg")).build(), PlanMatchPattern.values("msg", "z")))));
    }

    @Test
    public void testPushdownDereferenceThroughRowNumber() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughRowNumber(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_x"), PlanBuilder.expression("msg2.x")).build(), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), Optional.empty(), p.symbol("row_number"), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression("msg1.x")).put((Object)"msg2_x", (Object)PlanMatchPattern.expression("expr")).build(), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"msg1")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"expr", (Object)PlanMatchPattern.expression("msg2.x")).put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).build(), PlanMatchPattern.values("msg1", "msg2")))));
    }

    @Test
    public void testPushdownDereferenceThroughTopNRowNumber() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughTopNRowNumber(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_x"), PlanBuilder.expression("msg2.x")).put(p.symbol("msg3_x"), PlanBuilder.expression("msg3.x")).build(), (PlanNode)p.topNRowNumber(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (Map)ImmutableMap.of((Object)p.symbol("msg2", (Type)ROW_TYPE), (Object)SortOrder.ASC_NULLS_FIRST)))), 5, p.symbol("row_number"), Optional.empty(), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("msg3", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression("msg1.x")).put((Object)"msg2_x", (Object)PlanMatchPattern.expression("msg2.x")).put((Object)"msg3_x", (Object)PlanMatchPattern.expression("expr")).build(), PlanMatchPattern.topNRowNumber(pattern -> pattern.specification(Collections.singletonList("msg1"), Collections.singletonList("msg2"), (Map<String, SortOrder>)ImmutableMap.of((Object)"msg2", (Object)SortOrder.ASC_NULLS_FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"expr", (Object)PlanMatchPattern.expression("msg3.x")).put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).put((Object)"msg3", (Object)PlanMatchPattern.expression("msg3")).build(), PlanMatchPattern.values("msg1", "msg2", "msg3")))));
    }

    @Test
    public void testPushdownDereferenceThroughTopN() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughTopN(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_x"), PlanBuilder.expression("msg2.x")).build(), (PlanNode)p.topN(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression("msg1.x")).put((Object)"msg2_x", (Object)PlanMatchPattern.expression("expr")).build(), PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("msg1", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"expr", (Object)PlanMatchPattern.expression("msg2.x")).put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).build(), PlanMatchPattern.values("msg1", "msg2")))));
    }

    @Test
    public void testPushdownDereferenceThroughWindow() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughWindow(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_x"), PlanBuilder.expression("msg2.x")).put(p.symbol("msg3_x"), PlanBuilder.expression("msg3.x")).put(p.symbol("msg4_x"), PlanBuilder.expression("msg4.x")).put(p.symbol("msg5_x"), PlanBuilder.expression("msg5.x")).build(), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (Map)ImmutableMap.of((Object)p.symbol("msg2", (Type)ROW_TYPE), (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("msg6", (Type)ROW_TYPE), (Object)new WindowNode.Function(MetadataManager.createTestMetadataManager().resolveFunction(QualifiedName.of((String)"min"), TypeSignatureProvider.fromTypes((Type[])new Type[]{ROW_TYPE})), (List)ImmutableList.of((Object)p.symbol("msg3", (Type)ROW_TYPE).toSymbolReference()), new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty()), true)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("msg3", (Type)ROW_TYPE), p.symbol("msg4", (Type)ROW_TYPE), p.symbol("msg5", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression("msg1.x")).put((Object)"msg2_x", (Object)PlanMatchPattern.expression("msg2.x")).put((Object)"msg3_x", (Object)PlanMatchPattern.expression("msg3.x")).put((Object)"msg4_x", (Object)PlanMatchPattern.expression("expr")).put((Object)"msg5_x", (Object)PlanMatchPattern.expression("expr2")).build(), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(Collections.singletonList("msg1"), Collections.singletonList("msg2"), (Map<String, SortOrder>)ImmutableMap.of((Object)"msg2", (Object)SortOrder.ASC_NULLS_FIRST)).addFunction(PlanMatchPattern.functionCall("min", Collections.singletonList("msg3"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).put((Object)"msg3", (Object)PlanMatchPattern.expression("msg3")).put((Object)"msg4", (Object)PlanMatchPattern.expression("msg4")).put((Object)"msg5", (Object)PlanMatchPattern.expression("msg5")).put((Object)"expr", (Object)PlanMatchPattern.expression("msg4.x")).put((Object)"expr2", (Object)PlanMatchPattern.expression("msg5.x")).build(), PlanMatchPattern.values("msg1", "msg2", "msg3", "msg4", "msg5")))));
    }

    @Test
    public void testPushdownDereferenceThroughAssignUniqueId() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughAssignUniqueId(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("expr"), PlanBuilder.expression("msg1.x")).build(), (PlanNode)p.assignUniqueId(p.symbol("unique"), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("msg1_x")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg1_x", (Object)PlanMatchPattern.expression("msg1.x")).build(), PlanMatchPattern.values("msg1")))));
    }

    @Test
    public void testPushdownDereferenceThroughMarkDistinct() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughMarkDistinct(this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), PlanBuilder.expression("msg1.x")).put(p.symbol("msg2_x"), PlanBuilder.expression("msg2.x")).build(), (PlanNode)p.markDistinct(p.symbol("is_distinct", (Type)BooleanType.BOOLEAN), Collections.singletonList(p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg1_x", (Object)PlanMatchPattern.expression("expr"), (Object)"msg2_x", (Object)PlanMatchPattern.expression("msg2.x")), PlanMatchPattern.markDistinct("is_distinct", Collections.singletonList("msg2"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1", (Object)PlanMatchPattern.expression("msg1")).put((Object)"msg2", (Object)PlanMatchPattern.expression("msg2")).put((Object)"expr", (Object)PlanMatchPattern.expression("msg1.x")).build(), PlanMatchPattern.values("msg1", "msg2")))));
    }

    @Test
    public void testMultiLevelPushdown() {
        RowType complexType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)BigintType.BIGINT), RowType.field((String)"f2", (Type)BigintType.BIGINT)})), RowType.field((String)"f2", (Type)BigintType.BIGINT)});
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject(this.tester().getTypeAnalyzer())).on(arg_0 -> TestPushDownDereferencesRules.lambda$testMultiLevelPushdown$23((Type)complexType, arg_0)).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression("a_f1"), (Object)"expr_2", (Object)PlanMatchPattern.expression("a_f1.f1 + 2 + b_f1_f1 + b_f1_f2")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"a_f1", (Object)PlanMatchPattern.expression("a.f1"), (Object)"b_f1_f1", (Object)PlanMatchPattern.expression("b.f1.f1"), (Object)"b_f1_f2", (Object)PlanMatchPattern.expression("b.f1.f2")), PlanMatchPattern.values("a", "b"))));
    }

    private static /* synthetic */ PlanNode lambda$testMultiLevelPushdown$23(Type complexType, PlanBuilder p) {
        return p.project(Assignments.of((Symbol)p.symbol("expr_1"), (Expression)PlanBuilder.expression("a.f1"), (Symbol)p.symbol("expr_2"), (Expression)PlanBuilder.expression("a.f1.f1 + 2 + b.f1.f1 + b.f1.f2")), (PlanNode)p.project(Assignments.identity((Iterable)ImmutableList.of((Object)p.symbol("a", complexType), (Object)p.symbol("b", complexType))), (PlanNode)p.values(p.symbol("a", complexType), p.symbol("b", complexType))));
    }
}

