/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughProject;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushLimitThroughProject
extends BaseRuleTest {
    public TestPushLimitThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownLimitNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testPushdownLimitWithTiesNNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedB, (Expression)new SymbolReference("b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedB", (Object)new ExpressionMatcher("b")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownLimitWithTiesThroughProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedC", (Object)new ExpressionMatcher("a + b")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownLimitWithTiesThroughProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedC), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushdownLimitThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushDownLimitThroughExclusiveDereferences() {
        RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("b"), (Expression)new DereferenceExpression((Expression)a.toSymbolReference(), new Identifier("x")), (Symbol)p.symbol("c"), (Expression)new DereferenceExpression((Expression)a.toSymbolReference(), new Identifier("y"))), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testPushDownLimitThroughOverlappingDereferences() {
        RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("b"), (Expression)new DereferenceExpression((Expression)a.toSymbolReference(), new Identifier("x")), (Symbol)p.symbol("c", (Type)rowType), (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("a.x"), (Object)"c", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.limit(1L, PlanMatchPattern.values("a"))));
    }
}

