/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.TpchTableLayoutHandle;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPushPredicateIntoTableScan
extends BaseRuleTest {
    private PushPredicateIntoTableScan pushPredicateIntoTableScan;
    private TableHandle nationTableHandle;
    private TableHandle ordersTableHandle;

    public TestPushPredicateIntoTableScan() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setUpBeforeClass() {
        this.pushPredicateIntoTableScan = new PushPredicateIntoTableScan(this.tester().getMetadata(), new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()));
        CatalogName catalogName = this.tester().getCurrentConnectorId();
        TpchTableHandle nation = new TpchTableHandle("nation", 1.0);
        this.nationTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)nation, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(nation, TupleDomain.all())));
        TpchTableHandle orders = new TpchTableHandle("orders", 1.0);
        this.ordersTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)orders, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(orders, TupleDomain.all())));
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
    }

    @Test
    public void eliminateTableScanWhenNoLayoutExist() {
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'G'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void replaceWithExistsWhenNoLayoutExist() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$replaceWithExistsWhenNoLayoutExist$2((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsSame() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsSame$3((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsWider$4((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsNarrower() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        TpchColumnHandle columnHandle = new TpchColumnHandle("orderstatus", (Type)orderStatusType);
        ImmutableMap filterConstraint = ImmutableMap.builder().put((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))).build();
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsNarrower$5((Type)orderStatusType, (ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void doesNotConsumeRemainingPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$doesNotConsumeRemainingPredicateIfNewDomainIsWider$6((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.filter((Expression)new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "17")), (Expression)new GenericLiteral("BIGINT", "44"))), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void doesNotFireOnNonDeterministicPredicate() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$doesNotFireOnNonDeterministicPredicate$7((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void doesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("nationkey % 17 =  BIGINT '44' AND nationkey % 15 =  BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all()))).doesNotFire();
    }

    @Test
    public void ruleAddedTableLayoutToFilterTableScan() {
        ImmutableMap filterConstraint = ImmutableMap.builder().put((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))).build();
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void nonDeterministicPredicate() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$nonDeterministicPredicate$10((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new LongLiteral("0")), PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))));
    }

    private /* synthetic */ PlanNode lambda$nonDeterministicPredicate$10(Type orderStatusType, PlanBuilder p) {
        return p.filter((Expression)new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("orderstatus"), (Expression)new StringLiteral("O")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new LongLiteral("0"))), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$doesNotFireOnNonDeterministicPredicate$7(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new LongLiteral("42")), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()));
    }

    private /* synthetic */ PlanNode lambda$doesNotConsumeRemainingPredicateIfNewDomainIsWider$6(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "17")), (Expression)new GenericLiteral("BIGINT", "44"))), (Expression)new LogicalBinaryExpression(LogicalBinaryExpression.Operator.OR, (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "44")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "45")))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsNarrower$5(Type orderStatusType, ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("orderstatus = 'O' OR orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType)), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.multipleValues((Type)orderStatusType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"O"), (Object)Slices.utf8Slice((String)"P")))))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsWider$4(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44' OR nationkey = BIGINT '45'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsSame$3(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$replaceWithExistsWhenNoLayoutExist$2(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)45L)))));
    }
}

