/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantEnforceSingleRowNode;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestRemoveRedundantEnforceSingleRowNode
extends BaseRuleTest {
    public TestRemoveRedundantEnforceSingleRowNode() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveEnforceWhenSourceScalar() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantEnforceSingleRowNode()).on(p -> p.enforceSingleRow((PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("a")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.values("a")));
    }

    @Test
    public void testDoNotFireWhenSourceNotScalar() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantEnforceSingleRowNode()).on(p -> p.enforceSingleRow((PlanNode)p.values(10, p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveRedundantEnforceSingleRowNode()).on(p -> p.enforceSingleRow((PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }
}

