/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantJoin;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import org.testng.annotations.Test;

public class TestRemoveRedundantJoin
extends BaseRuleTest {
    public TestRemoveRedundantJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testInnerJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(0, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a"));
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(0, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("b"));
    }

    @Test
    public void testLeftJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(0, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a"));
    }

    @Test
    public void testRightJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(0, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a"));
    }
}

